import { isNothing, isSome } from "@jet/environment";
import * as models from "../../../api/models";
import { attributeAsString } from "../../../foundation/media/attributes";
import * as contentArtwork from "../../content/artwork/artwork";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    var _a;
    let developerName = lockup.developerName;
    if (isNothing(developerName)) {
        developerName = (_a = attributeAsString(data, "artistName")) !== null && _a !== void 0 ? _a : attributeAsString(data, "developerName");
    }
    if (developerName != null) {
        if (dedupeSet.has(developerName)) {
            return null;
        }
        else {
            dedupeSet.add(developerName);
        }
    }
    if (isSome(developerName) && developerName.length > 0) {
        const developerItem = new models.MetadataRibbonItem("imageWithLabel");
        developerItem.moduleType = "developerInfo";
        developerItem.labelText = developerName;
        developerItem.artwork = contentArtwork.createArtworkForResource(objectGraph, "systemimage://person.crop.square");
        const characterCountThreshold = 6;
        developerItem.maxCharacterCount = 16;
        developerItem.truncationLegibilityCharacterCountThreshold = Math.min(characterCountThreshold, developerName.length);
        developerItem.allowsTruncation = developerName.length >= characterCountThreshold;
        const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "developerInfo", developerItem.labelText, "static");
        metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, developerItem, impressionOptions);
        return [developerItem];
    }
    else {
        return null;
    }
}
//# sourceMappingURL=developer-metadata-ribbon-item.js.map