import { isSome, isNothing } from "@jet/environment/types/optional";
import { MetadataRibbonItem } from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import { contentAttributeAsDictionary } from "../../content/attributes";
import { badgeChartKeyForClientIdentifier } from "../../content/content";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    var _a, _b;
    const chartData = chartFromData(objectGraph, data);
    if (serverData.isNullOrEmpty(chartData)) {
        return null;
    }
    const position = serverData.asNumber(chartData, "position");
    /// Per product, if the app isn't charting in the top 50, we don't want to use the chart module
    if (isNothing(position) || position > 50) {
        return null;
    }
    const genreName = (_a = serverData.asString(chartData, "genreShortName")) !== null && _a !== void 0 ? _a : serverData.asString(chartData, "genreName");
    if (genreName != null) {
        if (dedupeSet.has(genreName)) {
            return null;
        }
        else {
            dedupeSet.add(genreName);
        }
    }
    let chartItem;
    if (objectGraph.bag.isLLMSearchTagsEnabled) {
        chartItem = new MetadataRibbonItem("highlightedText");
    }
    else {
        chartItem = new MetadataRibbonItem("borderedTextLabel");
    }
    chartItem.moduleType = "chartPositions";
    // Only use an ad override locale if this is an ad.
    const adsOverrideLanguage = isSome((_b = lockup.searchAdOpportunity) === null || _b === void 0 ? void 0 : _b.searchAd) || isSome(lockup.searchAd)
        ? objectGraph.bag.adsOverrideLanguage
        : null;
    const useAdsLocale = isSome(adsOverrideLanguage);
    const loc = useAdsLocale ? objectGraph.adsLoc : objectGraph.loc;
    // MAINTAINER'S NOTE: This was previously guarded by the iOS only `search_tags` feature flag that has been enabled by default on iOS only.
    if (objectGraph.client.isiOS) {
        const chartPositionText = loc
            .string("MetadataRibbon.ChartPosition")
            .replace("@@chartPosition@@", objectGraph.loc.formattedCountForPreferredLocale(objectGraph, position, adsOverrideLanguage));
        if (objectGraph.bag.isLLMSearchTagsEnabled) {
            chartItem.highlightedText = chartPositionText;
            chartItem.labelText = loc
                .string("MetadataRibbon.ChartPositionAndCategory.Tags")
                .replace("@@chartPosition@@", objectGraph.loc.formattedCountForPreferredLocale(objectGraph, position, adsOverrideLanguage))
                .replace("@@category@@", genreName);
        }
        else {
            chartItem.labelText = genreName;
            chartItem.borderedText = chartPositionText;
        }
    }
    chartItem.secondaryViewPlacement = "leading";
    const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "chartPosition", chartItem.labelText, "static");
    metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, chartItem, impressionOptions);
    return [chartItem];
}
export function chartFromData(objectGraph, data) {
    const chartPositionsByStore = contentAttributeAsDictionary(objectGraph, data, "chartPositions");
    if (serverData.isNullOrEmpty(chartPositionsByStore)) {
        return null;
    }
    const storeChartKey = badgeChartKeyForClientIdentifier(objectGraph, objectGraph.host.clientIdentifier);
    if (serverData.isNullOrEmpty(storeChartKey)) {
        return null;
    }
    const chartData = serverData.asDictionary(chartPositionsByStore, storeChartKey);
    return chartData;
}
//# sourceMappingURL=chart-metadata-ribbon-item.js.map