import * as serverData from "../../foundation/json-parsing/server-data";
import { isNothing, isSome } from "@jet/environment";
import { asDictionary } from "@apple-media-services/media-api";
import { artworkFromApiArtwork } from "../content/content";
import { asString } from "../../foundation/json-parsing/server-data";
import { Video } from "../../api/models";
export function getSelectedCustomCreativeId(data) {
    if (preprocessor.CARRY_BUILD || preprocessor.DEBUG_BUILD) {
        const customCreativeMeta = asDictionary(data, "meta.creativeAttributes");
        const selectedCustomCreativeId = asString(customCreativeMeta, "creatives.0");
        return selectedCustomCreativeId;
    }
    return null;
}
/**
 * Create a custom creative artwork from the data.
 * @param objectGraph Object graph
 * @param data that we use to populate custom creative artwork
 * @param customCreativeData where we store custom creative data.
 * @param cropCode for the artwork
 */
export function customCreativeArtworkFromData(objectGraph, data, customCreativeData, cropCode) {
    if (preprocessor.CARRY_BUILD || preprocessor.DEBUG_BUILD) {
        const selectedCustomCreativeId = getSelectedCustomCreativeId(data);
        if (isNothing(customCreativeData) || isNothing(selectedCustomCreativeId)) {
            return null;
        }
        const creativeAssetArtwork = artworkFromApiArtwork(objectGraph, serverData.asDictionary(customCreativeData, `${selectedCustomCreativeId}.adCreativeArtwork`), {
            allowingTransparency: false,
            useCase: 4 /* ArtworkUseCase.LockupScreenshots */,
        });
        if (isSome(cropCode) && isSome(creativeAssetArtwork)) {
            creativeAssetArtwork.crop = cropCode;
        }
        return creativeAssetArtwork;
    }
    else {
        return null;
    }
}
/**
 * Create a custom creative video from the data.
 * @param objectGraph Object graph
 * @param data that we use to populate custom creative video and preview.
 * @param videoConfiguration for the custom creative video.
 * @param customCreativeData where we store custom creative data.
 * @param cropCode for the artwork
 */
export function customCreativeVideoFromData(objectGraph, data, customCreativeData, videoConfiguration, cropCode) {
    if (preprocessor.CARRY_BUILD || preprocessor.DEBUG_BUILD) {
        const selectedCustomCreativeId = getSelectedCustomCreativeId(data);
        if (isNothing(selectedCustomCreativeId)) {
            return null;
        }
        const creativeVideoData = serverData.asDictionary(customCreativeData, `${selectedCustomCreativeId}.adCreativeVideo`);
        const videoUrl = serverData.asString(creativeVideoData, "video");
        const preview = artworkFromApiArtwork(objectGraph, serverData.asDictionary(creativeVideoData, "previewFrame"), {
            allowingTransparency: false,
            useCase: 4 /* ArtworkUseCase.LockupScreenshots */,
        });
        if (isNothing(videoUrl) || isNothing(preview)) {
            return null;
        }
        if (isSome(cropCode)) {
            preview.crop = cropCode;
        }
        return new Video(videoUrl, preview, videoConfiguration);
    }
    return null;
}
//# sourceMappingURL=custom-creative.js.map