import { Request, defaultAdditionalPlatformsForClient } from "../../foundation/media/data-fetching";
import { shouldFetchCustomAttributes } from "../product-page/product-page-variants";
import { shouldUsePrerenderedIconArtwork } from "../content/content";
import { setPreviewPlatform } from "../preview-platform";
export function createRoomRequest(objectGraph, roomId) {
    const mediaApiRequest = new Request(objectGraph)
        .withIdOfType(roomId, "rooms")
        .includingAgeRestrictions()
        .includingMacOSCompatibleIOSAppsWhenSupported(true);
    if (objectGraph.client.isWeb) {
        mediaApiRequest.includingAdditionalPlatforms(defaultAdditionalPlatformsForClient(objectGraph));
        setPreviewPlatform(objectGraph, mediaApiRequest);
    }
    return mediaApiRequest;
}
export function prepareRoomRequest(objectGraph, request) {
    return request
        .includingAdditionalPlatforms(defaultAdditionalPlatformsForClient(objectGraph))
        .includingAttributes(defaultAttributesForRoomRequest(objectGraph))
        .usingCustomAttributes(shouldFetchCustomAttributes(objectGraph))
        .includingAgeRestrictions()
        .includingMacOSCompatibleIOSAppsWhenSupported(true);
}
export function defaultAttributesForRoomRequest(objectGraph) {
    const attributes = [
        "editorialArtwork",
        "editorialVideo",
        "isAppleWatchSupported",
        "requiredCapabilities",
    ];
    if (objectGraph.appleSilicon.isSupportEnabled) {
        attributes.push("macRequiredCapabilities");
    }
    if (objectGraph.client.isMac) {
        attributes.push("hasMacIPAPackage");
    }
    if (objectGraph.client.isVision) {
        attributes.push("compatibilityControllerRequirement");
    }
    if (objectGraph.bag.enableUpdatedAgeRatings) {
        attributes.push("ageRating");
    }
    if (shouldUsePrerenderedIconArtwork(objectGraph)) {
        attributes.push("iconArtwork");
    }
    return attributes;
}
//# sourceMappingURL=room-request.js.map