import * as models from "../../../api/models";
import * as productBadges from "../badges/badges";
import * as productPageUtil from "../product-page-util";
/**
 * Create a shelf for the product page ribbon to display badges.
 *
 * @param data The raw data response for a product page JSON fetch.
 * @param shelfMetrics The product page shelf metrics.
 * @returns A ribbon shelf.
 */
export function create(objectGraph, data, shelfMetrics, shelfContext) {
    if (productPageUtil.isShelfBased(objectGraph)) {
        const badgeShelf = new models.Shelf("productBadge");
        const badges = productBadges.badgesFromResponse(objectGraph, data, true, {
            locationTracker: shelfMetrics.locationTracker,
            pageInformation: shelfMetrics.metricsPageInformation,
        });
        badgeShelf.items = badges;
        badgeShelf.isHorizontal = true;
        shelfMetrics.addImpressionsToShelf(objectGraph, badgeShelf, "informationRibbon");
        return badgeShelf;
    }
    else {
        const ribbonShelf = new models.Shelf("informationRibbon");
        const badges = productBadges.badgesFromResponse(objectGraph, data, true, {
            locationTracker: shelfMetrics.locationTracker,
            pageInformation: shelfMetrics.metricsPageInformation,
        });
        const hasTopSeparator = !shelfContext.useInlineUberStyle;
        const hasBottomSeparator = false;
        const separatorsAreFullWidth = shelfContext.useInlineUberStyle;
        const alignment = "justified";
        const informationRibbon = new models.InformationRibbon(badges, hasTopSeparator, hasBottomSeparator, separatorsAreFullWidth, alignment);
        ribbonShelf.items = [informationRibbon];
        ribbonShelf.isHorizontal = true;
        shelfMetrics.addImpressionsToShelf(objectGraph, ribbonShelf, "informationRibbon");
        return ribbonShelf;
    }
}
//# sourceMappingURL=ribbon-shelf.js.map