import * as validation from "@jet/environment/json/validation";
import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as mediaDataStructure from "../../../foundation/media/data-structure";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
import * as todayHorizontalCardUtil from "../../today/today-horizontal-card-util";
import * as productPageCommon from "../product-page-common";
/**
 * Create a shelf for the `featured in` product page shelf.
 *
 * @param productData The product data response for a product page JSON fetch.
 * @param dataContainer The raw data response for a product page JSON fetch.
 * @param shelfMetrics The product page shelf metrics.
 * @returns A shelf to display the featured in items.
 */
export function create(objectGraph, productData, dataContainer, shelfMetrics) {
    function featuredInItemsFromData(innerObjectGraph, container, metricsOptions, contentUnavailable) {
        return todayHorizontalCardUtil.featuredInTodayCardsFromData(innerObjectGraph, container.data, metricsOptions.pageInformation, metricsOptions.locationTracker, productPageCommon.includeTodayCardOnProductPage, contentUnavailable);
    }
    return validation.context("featuredInShelf", () => {
        const data = mediaDataStructure.dataFromDataContainer(objectGraph, dataContainer);
        if (serverData.isNullOrEmpty(data)) {
            return null;
        }
        const metricsOptions = {
            pageInformation: shelfMetrics.metricsPageInformation,
            locationTracker: shelfMetrics.locationTracker,
            targetType: "swoosh",
            id: `${shelfMetrics.getSequenceId()}`,
            idType: "sequential",
        };
        const shelf = new models.Shelf("todayBrick");
        const title = objectGraph.loc.string("ProductPage.Section.FeaturedIn.Title");
        shelf.title = title;
        shelf.isHorizontal = false;
        const remainingItems = [];
        const cardUnavailable = function (cardData) {
            remainingItems.push(cardData);
            return false;
        };
        shelf.items = [featuredInItemsFromData(objectGraph, dataContainer, metricsOptions, cardUnavailable)];
        if (serverData.isDefinedNonNullNonEmpty(remainingItems)) {
            const shelfToken = new productPageCommon.ProductPageShelfToken(productData.id, remainingItems, shelf.title, false, undefined, "todayBrick");
            shelf.url = productPageCommon.shelfContentUrl(objectGraph, shelfToken, shelfMetrics);
        }
        metricsHelpersLocation.pushContentLocation(objectGraph, metricsOptions, title);
        shelfMetrics.addImpressionsToShelf(objectGraph, shelf, "featuredIn");
        metricsHelpersLocation.popLocation(shelfMetrics.locationTracker);
        metricsHelpersLocation.nextPosition(shelfMetrics.locationTracker);
        return shelf;
    });
}
//# sourceMappingURL=featured-in-shelf.js.map