import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as color from "../../../foundation/util/color-util";
import * as contentAttributes from "../../content/attributes";
/**
 * Create a shelf for the editorial quote on the product page.
 *
 * @param data The raw data response for a product page JSON fetch.
 * @param shelfMetrics The product page shelf metrics.
 * @returns An editorial quote shelf.
 */
export function create(objectGraph, data, shelfMetrics) {
    if (serverData.isNullOrEmpty(data)) {
        return null;
    }
    const editorialNotes = contentAttributes.contentAttributeAsDictionary(objectGraph, data, "editorialNotes");
    const standardNotes = serverData.asString(editorialNotes, "standard");
    if (standardNotes) {
        const attribution = objectGraph.loc.string("APP_STORE_EDITORS_ATTRIBUTION");
        // Create the quote
        const editorialQuote = new models.EditorialQuote(standardNotes, attribution);
        // Create the shelf
        const shelf = new models.Shelf("editorialQuote");
        shelf.items = [editorialQuote];
        shelfMetrics.addImpressionsToShelf(objectGraph, shelf, "editorialQuote");
        if (objectGraph.client.isiOS) {
            shelf.background = {
                type: "color",
                color: color.named("componentBackgroundStandout"),
            };
        }
        return shelf;
    }
    return null;
}
//# sourceMappingURL=editorial-quote-shelf.js.map