import * as validation from "@jet/environment/json/validation";
import * as models from "../../../api/models";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
import * as productPageCommon from "./../product-page-common";
/**
 * Create a shelf of bundle children for the product page.
 *
 * @param productData The raw product data response for a product page JSON fetch.
 * @param dataContainer The raw data container response for a product page JSON fetch.
 * @param shelfMetrics The product page shelf metrics.
 * @returns A shelf of bundle children.
 */
export function create(objectGraph, productData, dataContainer, shelfMetrics) {
    if (!dataContainer) {
        return null;
    }
    return validation.context("bundleChildrenShelf", () => {
        const shelfContentType = "smallLockup";
        const shelf = new models.Shelf(shelfContentType);
        shelf.isHorizontal = true;
        const numberOfChildren = dataContainer.data.length;
        if (!numberOfChildren) {
            return null;
        }
        shelf.title = objectGraph.loc.stringWithCount("ProductPage.AppsInBundleShelf.Title", numberOfChildren);
        const containerItems = productPageCommon.lockupsFromDataContainer(objectGraph, dataContainer, shelfMetrics, 1 /* content.ArtworkUseCase.LockupIconSmall */, shelfContentType, null, 76286 /* filtering.Filter.Bundles */, null, objectGraph.featureFlags.isEnabled("voyager_bundles_2025A"));
        if (containerItems.remainingItems.length) {
            const shelfToken = new productPageCommon.ProductPageShelfToken(productData.id, containerItems.remainingItems, shelf.title, false, undefined, "smallLockup", "infer", null);
            shelfToken.isBundleShelf = true;
            shelf.url = productPageCommon.shelfContentUrl(objectGraph, shelfToken, shelfMetrics);
        }
        metricsHelpersLocation.pushContentLocation(objectGraph, {
            pageInformation: shelfMetrics.metricsPageInformation,
            locationTracker: shelfMetrics.locationTracker,
            targetType: "swoosh",
            id: `${shelfMetrics.getSequenceId()}`,
            idType: "sequential",
        }, shelf.title);
        shelf.items = containerItems.items;
        metricsHelpersLocation.popLocation(shelfMetrics.locationTracker);
        shelfMetrics.addImpressionsToShelf(objectGraph, shelf, "bundleChildren");
        metricsHelpersLocation.nextPosition(shelfMetrics.locationTracker);
        if (numberOfChildren < 2 || objectGraph.client.isTV) {
            shelf.rowsPerColumn = 1;
        }
        else {
            shelf.rowsPerColumn = 2;
        }
        return shelf;
    });
}
//# sourceMappingURL=bundle-children-shelf.js.map