import * as models from "../../../../api/models/index";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import * as contentAttributes from "../../../content/attributes";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    const versions = contentAttributes.contentAttributeAsArrayOrEmpty(objectGraph, data, "versionHistory");
    if (versions.length === 0) {
        return null;
    }
    const latestVersion = versions[0];
    let releaseDate = null;
    const releaseDateRaw = serverData.asString(latestVersion, "releaseDate");
    if (releaseDateRaw) {
        const releaseDateFormat = objectGraph.loc.string("ProductPage.VersionAnnotation.Value.DateFormat");
        releaseDate = objectGraph.loc.formatDate(releaseDateFormat, new Date(releaseDateRaw));
    }
    const versionDisplay = serverData.asString(latestVersion, "versionDisplay");
    if (versions.length === 0) {
        return null;
    }
    let versionItemString;
    if (versionDisplay && releaseDate) {
        versionItemString = objectGraph.loc
            .string("ProductPage.VersionAnnotation.Value")
            .replace("@@version@@", versionDisplay)
            .replace("@@date@@", releaseDate);
    }
    else if (versionDisplay) {
        versionItemString = versionDisplay;
    }
    else {
        return null;
    }
    const versionItem = new models.AnnotationItem(versionItemString);
    const title = suppressTitle ? "" : objectGraph.loc.string("ProductPage.VersionAnnotation.Title");
    const version = new models.Annotation(title, [versionItem]);
    if (version && !isArcadeApp) {
        return version;
    }
    return null;
}
//# sourceMappingURL=version-annotation.js.map