import * as models from "../../../../api/models/index";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import * as artwork from "../../../content/artwork/artwork";
import { isSome, isNothing } from "@jet/environment";
import { ageVerificationAnnotationItemIfNeeded } from "./content-rating-annotation";
import { storefrontContentRatingResourceForRank } from "../../../content/content";
/**
 * Only used by TV. Shows the full annotation by default without needing to expand.
 */
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    const annotationItems = [];
    const storefrontContentRating = contentRatingPictogramRowIfNeeded(objectGraph, data);
    if (isSome(storefrontContentRating)) {
        annotationItems.push(storefrontContentRating);
    }
    const ageVerificationAnnotationItem = ageVerificationAnnotationItemIfNeeded(objectGraph, data);
    if (isSome(ageVerificationAnnotationItem)) {
        annotationItems.push(ageVerificationAnnotationItem);
    }
    if (annotationItems.length === 0) {
        return null;
    }
    const title = objectGraph.loc.string("InfoList.AgeRating.Title.KR");
    const annotation = new models.Annotation(title, annotationItems);
    annotation.shouldAlwaysPresentExpanded = true;
    return annotation;
}
export function contentRatingPictogramRowIfNeeded(objectGraph, data) {
    const krContentRating = mediaAttributes.attributeAsDictionary(data, "contentRatingsBySystem.appsKorea");
    if (isNothing(krContentRating)) {
        return null;
    }
    const krContentRank = serverData.asNumber(krContentRating, "rank");
    if (isNothing(krContentRank)) {
        return null;
    }
    const krContentAdvisory = serverData.asArrayOrEmpty(krContentRating, "advisories")[0];
    if (isNothing(krContentAdvisory)) {
        return null;
    }
    // Make sure we have a content rank, and the rank is not 19+. 19+ pictogram is not displayed.
    const pictogramResource = storefrontContentRatingResourceForRank(objectGraph, krContentRank);
    const krRatingPictograms = [];
    if (isSome(pictogramResource)) {
        krRatingPictograms.push(artwork.createArtworkForResource(objectGraph, `resource://${pictogramResource}`));
    }
    const pictogramRow = new models.AnnotationItem(krContentAdvisory, {
        headingArtworks: krRatingPictograms,
    });
    return pictogramRow;
}
//# sourceMappingURL=storefront-content-rating-annotation.js.map