import { isNothing, isSome } from "@jet/environment";
import * as models from "../../../../api/models/index";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import { createArtworkForResource } from "../../../content/artwork/artwork";
import * as gameController from "./../../../content/game-controller";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    if (!objectGraph.client.isVision) {
        return null;
    }
    const isRequired = gameController.isSpatialControllerRequired(objectGraph, data);
    if (!isRequired) {
        return null;
    }
    const title = suppressTitle ? "" : objectGraph.loc.string("ProductPage.Info.SpatialController.Title");
    const summary = objectGraph.loc.string("ProductPage.Info.SpatialController.Required.Summary");
    // Items
    const artistName = mediaAttributes.attributeAsString(data, "artistName");
    if (isNothing(artistName) || artistName.length === 0) {
        return null;
    }
    const itemText = objectGraph.loc
        .string("ProductPage.Info.SpatialController.Required.Item")
        .replace("{developerName}", artistName);
    const styledText = new models.StyledText(itemText);
    const items = [
        {
            $kind: "linkableText",
            linkableText: new models.LinkableText(styledText),
        },
    ];
    // Learn More link
    const storyId = objectGraph.bag.spatialControlsLearnMoreEditorialItemId;
    if (isSome(storyId) && storyId.length > 0) {
        // The native support for the `small` spacer was introduced in 2025B. Older clients will just ignore this
        // and show the standard size space, which is still preferable over no space at all.
        items.push({
            $kind: "spacer",
            size: "small",
        });
        const actionTitle = objectGraph.loc.string("Action.LearnMore");
        const flowAction = new models.FlowAction("article");
        flowAction.title = actionTitle;
        flowAction.pageUrl = `https://apps.apple.com/story/id${storyId}`;
        const dismissAction = new models.FlowBackAction("sheetDismiss");
        const linkAction = new models.CompoundAction([dismissAction, flowAction]);
        linkAction.title = actionTitle;
        const linkedSubstrings = {};
        linkedSubstrings[actionTitle] = linkAction;
        items.push({
            $kind: "linkableText",
            linkableText: new models.LinkableText(new models.StyledText(actionTitle), linkedSubstrings),
        });
    }
    const annotation = new models.Annotation(title, [], summary);
    annotation.items_V3 = items;
    annotation.leadingArtwork = createArtworkForResource(objectGraph, "resource://SpatialControllers");
    annotation.prefersSmallLeadingArtwork = true;
    return annotation;
}
//# sourceMappingURL=spatial-controller-annotation.js.map