import * as validation from "@jet/environment/json/validation";
import * as models from "../../../../api/models/index";
import { productCapabilitiesFromData } from "../../../content/product-capabilities";
import { translateItemsToV3 } from "./annotations";
export function createAnnotations(objectGraph, productData, isFreeProduct) {
    return validation.context("productCapabilitiesAsAnnotations", () => {
        const annotations = [];
        const capabilities = productCapabilitiesFromData(objectGraph, productData, isFreeProduct);
        for (const capability of capabilities) {
            const title = capability.title;
            const text = capability.caption.styledText.rawText;
            if ((title === null || title === void 0 ? void 0 : title.length) > 0 && (text === null || text === void 0 ? void 0 : text.length) > 0) {
                const annotationItem = new models.AnnotationItem(text);
                const annotation = new models.Annotation(title, [annotationItem]);
                // Don't overwrite existing items
                if (annotation.items_V3.length === 0) {
                    annotation.items_V3 = translateItemsToV3(objectGraph, annotation);
                }
                annotations.push(annotation);
            }
        }
        return annotations;
    });
}
//# sourceMappingURL=product-capabilities-annotation.js.map