import * as models from "../../../../api/models/index";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import { createArtworkForResource } from "../../../content/artwork/artwork";
import { contentAttributeAsBooleanOrFalse } from "../../../content/attributes";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    // The "High Motion" flag shouldn't appear in data for other platform apps, but to be sure
    // we don't want the annotation appearing anywhere else accidentally.
    if (!objectGraph.client.isVision) {
        return null;
    }
    const isHighMotion = contentAttributeAsBooleanOrFalse(objectGraph, data, "isHighMotion");
    if (!isHighMotion) {
        return null;
    }
    const artwork = createArtworkForResource(objectGraph, "resource://motion.circle.fill");
    const highMotionAnnotationItem = new models.AnnotationItem(objectGraph.loc.string("ProductPage.Info.HighMotion.Item.Description"), { heading: objectGraph.loc.string("ProductPage.Info.HighMotion.Item.Heading") });
    const highMotionAnnotationItemHeading = objectGraph.loc.string("ProductPage.Info.HighMotion.Item.Heading");
    const highMotionAnnotationItemDescription = objectGraph.loc.string("ProductPage.Info.HighMotion.Item.Description");
    const highMotionAnnotationItems_V3 = [
        {
            $kind: "linkableText",
            linkableText: new models.LinkableText(new models.StyledText(`**${highMotionAnnotationItemHeading}**\n\n${highMotionAnnotationItemDescription}`)),
        },
    ];
    const title = suppressTitle ? "" : objectGraph.loc.string("Annotations.HighMotion.Title");
    const summary = objectGraph.loc.string("Annotations.HighMotion.Summary");
    // Learn More link
    let learnMoreAction;
    if (serverData.isDefinedNonNullNonEmpty(objectGraph.bag.highMotionLearnMoreEditorialItemId)) {
        const flowAction = new models.FlowAction("article");
        flowAction.title = objectGraph.loc.string("ProductPage.Info.HighMotion.LearnMore");
        flowAction.pageUrl = `https://apps.apple.com/story/id${objectGraph.bag.highMotionLearnMoreEditorialItemId}`;
        if (objectGraph.client.isVision) {
            const dismissAction = new models.FlowBackAction("sheetDismiss");
            learnMoreAction = new models.CompoundAction([dismissAction, flowAction]);
            learnMoreAction.title = flowAction.title;
        }
        else {
            learnMoreAction = flowAction;
        }
        highMotionAnnotationItems_V3.push({
            $kind: "button",
            action: learnMoreAction,
        });
    }
    const annotation = new models.Annotation(title, [highMotionAnnotationItem], summary, learnMoreAction);
    annotation.leadingArtwork = artwork;
    annotation.expandedArtwork = artwork;
    annotation.prefersSmallLeadingArtwork = true;
    annotation.items_V3 = highMotionAnnotationItems_V3;
    return annotation;
}
//# sourceMappingURL=high-motion-annotation.js.map