import { isSome } from "@jet/environment/types/optional";
import * as models from "../../../../api/models/index";
import { externalPurchasesLearnMoreAction, externalPurchasesPlacementIsEnabled, hasExternalPurchasesForData, } from "../../../offers/external-purchases";
import { createArtworkForResource } from "../../../content/artwork/artwork";
/**
 * Creates the external purchases annotation, which is only present if an app is using external purchases, and this feature is enabled in the bag.
 */
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    const hasExternalPurchases = hasExternalPurchasesForData(objectGraph, data);
    const externalPurchasesEnabled = externalPurchasesPlacementIsEnabled(objectGraph, "product-page-info-section");
    if (!hasExternalPurchases || !externalPurchasesEnabled) {
        return null;
    }
    const title = suppressTitle ? "" : objectGraph.loc.string("Annotations.ExternalPurchases.Title");
    const summary = objectGraph.loc.string("YES");
    let itemText;
    if (isSome(objectGraph.bag.externalPurchasesProductPageAnnotationVariant)) {
        const key = `Annotations.ExternalPurchases.Expanded.Variant${objectGraph.bag.externalPurchasesProductPageAnnotationVariant}`;
        itemText = objectGraph.loc.string(key);
    }
    else {
        itemText = objectGraph.loc.string("Annotations.ExternalPurchases.Expanded");
    }
    const item = new models.AnnotationItem(itemText);
    const learnMoreTitle = objectGraph.loc.string("Annotations.ExternalPurchases.Expanded.LearnMore");
    const learnMoreAction = externalPurchasesLearnMoreAction(objectGraph, learnMoreTitle, shelfMetrics.metricsPageInformation, shelfMetrics.locationTracker);
    let wrappedLearnMoreAction = learnMoreAction;
    if (objectGraph.client.isVision && isSome(learnMoreAction)) {
        const dismissAction = new models.FlowBackAction("sheetDismiss");
        wrappedLearnMoreAction = new models.CompoundAction([dismissAction, learnMoreAction]);
        wrappedLearnMoreAction.title = learnMoreAction.title;
    }
    const annotation = new models.Annotation(title, [item], summary, wrappedLearnMoreAction !== null && wrappedLearnMoreAction !== void 0 ? wrappedLearnMoreAction : undefined);
    if (objectGraph.client.isVision) {
        annotation.leadingArtwork = createArtworkForResource(objectGraph, "systemimage://exclamationmark.triangle");
    }
    return annotation;
}
//# sourceMappingURL=external-purchases-annotation.js.map