import { isSome } from "@jet/environment/types/optional";
import * as models from "../../../../api/models/index";
import { createArtworkForResource } from "../../../content/artwork/artwork";
import { hasExternalBrowserForData } from "../../../content/content";
import * as metricsHelpersClicks from "../../../metrics/helpers/clicks";
import * as serverData from "../../../../foundation/json-parsing/server-data";
/**
 * Creates the external browser annotation, which is only present if an app is using an external browser engine.
 */
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    var _a;
    if (!hasExternalBrowserForData(objectGraph, data)) {
        return null;
    }
    const learnMoreAction = (_a = createExternalBrowserLearnMoreAction(objectGraph, shelfMetrics.metricsPageInformation, shelfMetrics.locationTracker)) !== null && _a !== void 0 ? _a : undefined;
    let linkAction = learnMoreAction;
    if (objectGraph.client.isVision && isSome(learnMoreAction)) {
        const dismissAction = new models.FlowBackAction("sheetDismiss");
        linkAction = new models.CompoundAction([dismissAction, learnMoreAction]);
        linkAction.title = learnMoreAction.title;
    }
    const title = suppressTitle ? "" : objectGraph.loc.string("Annotations.ExternalBrowser.Title");
    const summary = objectGraph.loc.string("Annotations.ExternalBrowser.Value.Summary");
    const itemText = objectGraph.loc.string("Annotations.ExternalBrowser.Value.Expanded");
    const items = [new models.AnnotationItem(itemText)];
    const annotation = new models.Annotation(title, items, summary, linkAction);
    if (objectGraph.client.isVision) {
        annotation.leadingArtwork = createArtworkForResource(objectGraph, "systemimage://exclamationmark.triangle");
    }
    return annotation;
}
/**
 * Creates a flow action for the external browser learn more story.
 * @param objectGraph Current object graph
 * @returns A flow action for the story, or null
 */
function createExternalBrowserLearnMoreAction(objectGraph, metricsPageInformation, metricsLocationTracker) {
    const editorialItemId = objectGraph.bag.externalBrowserLearnMoreEditorialItemId;
    if (serverData.isNullOrEmpty(editorialItemId)) {
        return null;
    }
    const flowAction = new models.FlowAction("article");
    flowAction.title = objectGraph.loc.string("Action.LearnMore");
    flowAction.pageUrl = `https://apps.apple.com/story/id${editorialItemId}`;
    metricsHelpersClicks.addClickEventToAction(objectGraph, flowAction, {
        id: "LearnMore",
        targetType: "link",
        actionType: "navigate",
        pageInformation: metricsPageInformation,
        locationTracker: metricsLocationTracker,
    });
    return flowAction;
}
//# sourceMappingURL=external-browser-annotation.js.map