import { isNothing } from "@jet/environment";
import * as models from "../../../../api/models/index";
import { createArtworkForResource } from "../../../content/artwork/artwork";
import * as contentAttributes from "../../../content/attributes";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    const copyrightString = contentAttributes.contentAttributeAsString(objectGraph, data, "copyright");
    if (isNothing(copyrightString)) {
        return null;
    }
    const copyrightItem = new models.AnnotationItem(copyrightString);
    const title = suppressTitle ? "" : objectGraph.loc.string("InfoList.Copyright");
    const annotation = new models.Annotation(title, [copyrightItem]);
    if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
        annotation.leadingArtwork = createArtworkForResource(objectGraph, "resource://copyright");
    }
    return annotation;
}
//# sourceMappingURL=copyright-annotation.js.map