import { isSome } from "@jet/environment";
import * as models from "../../../../api/models/index";
import { isFeatureEnabledForCurrentUser } from "../../../../common/util/lottery";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import { createArtworkForResource } from "../../../content/artwork/artwork";
import * as gameController from "./../../../content/game-controller";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    if (objectGraph.client.isVision && gameController.isSpatialControllerRequired(objectGraph, data)) {
        // Controllers and spatial controllers annotations are mutually exclusive
        return null;
    }
    const isFeatureEnabled = isFeatureEnabledForCurrentUser(objectGraph, objectGraph.bag.gameControllerRecommendedRolloutRate);
    const isRecommended = gameController.isGameControllerRecommended(objectGraph, data);
    const isRequired = objectGraph.client.isVision && gameController.isGameControllerRequired(objectGraph, data);
    const isSupported = preprocessor.GAMES_TARGET && gameController.isGameControllerSupported(objectGraph, data);
    if (isFeatureEnabled && (isRecommended || isRequired || isSupported)) {
        const title = suppressTitle ? "" : objectGraph.loc.string("ProductPage.Info.GameController.Title"); // Game Controller
        // Summary
        let summaryKey;
        if (preprocessor.GAMES_TARGET) {
            summaryKey = isRecommended
                ? "GameDetails.Annotation.Controller.Recommended.Title"
                : isRequired
                    ? "GameDetails.Annotation.Controller.Required.Title"
                    : "GameDetails.Annotation.Controller.Supported.Title";
        }
        else {
            summaryKey = isRecommended
                ? "ProductPage.Info.GameController.Recommended"
                : "ProductPage.Info.GameController.Required";
        }
        const summary = objectGraph.loc.string(summaryKey);
        // Items
        const artistName = mediaAttributes.attributeAsString(data, "artistName");
        const itemKey = isRecommended
            ? "ProductPage.Info.GameController.Recommended.Summary.v2"
            : "ProductPage.Info.GameController.Required.Summary.v2";
        const itemText = objectGraph.loc.string(itemKey).replace("{developerName}", artistName);
        const items = [new models.AnnotationItem(itemText)];
        // Learn More link
        let linkAction;
        const storyId = objectGraph.bag.gameControllerLearnMoreEditorialItemId;
        if (isSome(storyId) && storyId.length > 0) {
            const flowAction = new models.FlowAction("article");
            const titleKey = isRecommended
                ? "ProductPage.Info.GameController.Recommended.LearnMore"
                : "ProductPage.Info.GameController.Required.LearnMore";
            flowAction.title = objectGraph.loc.string(titleKey);
            flowAction.pageUrl = `https://apps.apple.com/story/id${storyId}`;
            if (objectGraph.client.isVision) {
                const dismissAction = new models.FlowBackAction("sheetDismiss");
                linkAction = new models.CompoundAction([dismissAction, flowAction]);
                linkAction.title = flowAction.title;
            }
            else {
                linkAction = flowAction;
            }
        }
        const annotation = new models.Annotation(title, items, summary, linkAction);
        if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
            annotation.leadingArtwork = createArtworkForResource(objectGraph, "systemimage://gamecontroller.fill");
            annotation.prefersSmallLeadingArtwork = true;
        }
        return annotation;
    }
    return null;
}
//# sourceMappingURL=controller-annotation.js.map