import { isNothing } from "@jet/environment";
import * as models from "../../../../api/models/index";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import { contentAttributeAsDictionary } from "../../../content/attributes";
import { artworkFromApiArtwork } from "../../../content/content";
import * as lockups from "../../../lockups/lockups";
export function createAnnotation(objectGraph, data, isFirstPartyHideableApp, isArcadeApp, suppressTitle, shelfMetrics) {
    var _a;
    if (isArcadeApp && !preprocessor.GAMES_TARGET) {
        // Design prefers we do not show the category annotation for Arcade apps
        return null;
    }
    const categoryName = lockups.categoryFromData(objectGraph, data);
    if (isNothing(categoryName)) {
        return null;
    }
    const categoryAnnotationItem = new models.AnnotationItem(categoryName);
    const title = suppressTitle ? "" : objectGraph.loc.string("InfoList.Category.Title");
    const summary = preprocessor.GAMES_TARGET ? categoryName : undefined;
    const annotation = new models.Annotation(title, [categoryAnnotationItem], summary);
    if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
        const artworkData = contentAttributeAsDictionary(objectGraph, data, "editorialArtwork.brandLogo");
        if (serverData.isDefinedNonNull(artworkData)) {
            annotation.leadingArtwork =
                (_a = artworkFromApiArtwork(objectGraph, artworkData, {
                    useCase: 0 /* ArtworkUseCase.Default */,
                    allowingTransparency: true,
                })) !== null && _a !== void 0 ? _a : undefined;
        }
    }
    return annotation;
}
//# sourceMappingURL=category-annotation.js.map