import * as validation from "@jet/environment/json/validation";
import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as mediaPlatformAttributes from "../../../foundation/media/platform-attributes";
import { Parameters, Path, Protocol } from "../../../foundation/network/url-constants";
import * as contentAttributes from "../../content/attributes";
import * as metricsHelpersClicks from "../../metrics/helpers/clicks";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
import * as productPageCommon from "../product-page-common";
import { makeGameCenterHeader, openGamesUIAction } from "../../arcade/arcade-common";
export function create(objectGraph, data, shelfMetrics, shelfContext) {
    return validation.context("achievementsShelf", () => {
        if (serverData.isNullOrEmpty(data)) {
            return null;
        }
        if (objectGraph.client.isWeb) {
            return null;
        }
        // rdar://66581575 (D421/18A342b: Achievements shouldn\u2019t be shown for pre-order games)
        if (shelfContext.isPreorder) {
            return null;
        }
        const isGameCenterEnabled = contentAttributes.contentAttributeAsBooleanOrFalse(objectGraph, data, "isGameCenterEnabled");
        if (!isGameCenterEnabled) {
            return null;
        }
        const attributePlatform = contentAttributes.bestAttributePlatformFromData(objectGraph, data);
        const bundleId = mediaPlatformAttributes.platformAttributeAsString(data, attributePlatform, "bundleId");
        if (serverData.isNullOrEmpty(bundleId)) {
            return null;
        }
        const title = objectGraph.loc.string("ProductPage.Section.Achievements.Title", "Achievements");
        const shelf = new models.Shelf("gameCenterPlayerGameAchievementSummary");
        shelf.header = makeGameCenterHeader(objectGraph, title);
        shelf.isHorizontal = true;
        shelf.items = [];
        shelf.mergeWhenFetched = true;
        const token = new productPageCommon.ProductPageShelfToken(data.id, [], shelf.title, false, undefined, null, null, null);
        token.sourceLocationTracker = shelfMetrics.locationTracker;
        token.destinationPageInformation = shelfMetrics.metricsPageInformation;
        shelf.url = `${Protocol.internal}:/${Path.product}/${Path.shelf}/?${Parameters.isGameCenterAchievementsShelf}=true&${Parameters.bundleId}=${bundleId}&${Parameters.token}=${productPageCommon.encodedShelfToken(token, shelfMetrics, shelfMetrics.metricsPageInformation)}`;
        shelf.batchGroup = "gameCenter";
        metricsHelpersLocation.nextPosition(shelfMetrics.locationTracker);
        shelf.footerTitle = objectGraph.loc.string("Lockup.Footer.GamesApp");
        shelf.footerAction = openGamesUIAction(objectGraph, { pageAchievements: {} });
        shelf.footerStyle = {
            $kind: "games",
            bundleID: "com.apple.games",
            width: 16,
            height: 16,
        };
        return shelf;
    });
}
export function createShelfWithAchievementSummary(objectGraph, achievementSummary, token) {
    const shelf = new models.Shelf("gameCenterPlayerGameAchievementSummary");
    shelf.isHorizontal = true;
    if (achievementSummary) {
        const impressionMetricsOptions = {
            pageInformation: token.destinationPageInformation,
            locationTracker: token.sourceLocationTracker,
            kind: "achievements",
            title: "Achievements",
            id: "achievements_summary",
            idType: "its_id",
            softwareType: null,
            targetType: "achievements",
            badges: {
                gameCenter: true,
            },
        };
        metricsHelpersImpressions.addImpressionFields(objectGraph, shelf, impressionMetricsOptions);
        metricsHelpersClicks.addClickEventToAction(objectGraph, achievementSummary.action, impressionMetricsOptions);
        shelf.items = [achievementSummary];
    }
    shelf.mergeWhenFetched = true;
    shelf.batchGroup = "gameCenter";
    shelf.isHidden = shelf.items.length === 0;
    return shelf;
}
//# sourceMappingURL=achievements-shelf.js.map