import * as models from "../../../api/models/index";
/**
 * ProductPageShelfMapping is a type that allows us to consolidate the logic around shelf
 * ordering between ShelfBasedProductPage and ProductPage for now until we move over
 * to ShelfBased completely.
 */
export class ProductPageSectionMapping {
    constructor(sectionType, shelfId, shelfBasedMappedIds) {
        this.sectionType = sectionType;
        this.shelfId = shelfId;
        this.shelfBasedMappedIds = shelfBasedMappedIds;
    }
    /// Create the ProductPageSection for this mapping
    createProductPageSection(objectGraph) {
        return models.legacyProductPageNonShelfSections.has(this.sectionType)
            ? new models.ProductPageSection(this.sectionType, null)
            : new models.ProductPageSection(this.sectionType, this.shelfId);
    }
    /// Create the list of shelfIds to use for this section when in a ShelfBasedProductPage
    createShelfIdList() {
        return this.shelfBasedMappedIds || [this.shelfId];
    }
}
/// Create the list of ProductPageSections for use with the non-ShelfBasedProduct pages
export function legacyProductPageSectionsFromMappings(objectGraph, sectionMappings) {
    return sectionMappings.map((mapping) => {
        return mapping.createProductPageSection(objectGraph);
    });
}
/// Create the list of ProductPageShelfIds for use with the ShelfBasedProduct pages
export function productPageShelfIdsFromMappings(sectionMappings) {
    return sectionMappings
        .map((mapping) => {
        return mapping.createShelfIdList();
    })
        .reduce((accumulator, currentValue) => {
        return accumulator.concat(currentValue);
    });
}
//# sourceMappingURL=product-page-section-mapping.js.map