import * as metricsHelpersImpressions from "../metrics/helpers/impressions";
import * as metricsHelpersLocation from "../metrics/helpers/location";
export class ProductPageShelfMetrics {
    constructor(metricsPageInformation, locationTracker, sequenceId = 0) {
        this.sequenceId = 0;
        this.metricsPageInformation = metricsPageInformation;
        this.locationTracker = locationTracker;
        this.sequenceId = sequenceId;
    }
    addImpressionsToShelf(objectGraph, shelf, targetType, overrideId, overrideIdType, recoMetricsData, title) {
        metricsHelpersImpressions.addImpressionFields(objectGraph, shelf, {
            id: overrideId !== null && overrideId !== void 0 ? overrideId : `${this.sequenceId}`,
            idType: overrideIdType !== null && overrideIdType !== void 0 ? overrideIdType : "sequential",
            kind: null,
            softwareType: null,
            targetType: targetType,
            title: title !== null && title !== void 0 ? title : shelf.title,
            pageInformation: this.metricsPageInformation,
            locationTracker: this.locationTracker,
            recoMetricsData: recoMetricsData,
        });
        this.sequenceId++;
    }
    getSequenceId() {
        return this.sequenceId;
    }
    // rdar://55462137 (Metrics: Swoosh "You May Also Like" instrumentation)
    addImpressionsFieldsToSimilarItemsShelf(objectGraph, shelf, targetType, idType) {
        if (!shelf) {
            return;
        }
        const options = {
            id: ProductPageShelfMetrics.similarItemsShelfId,
            kind: null,
            softwareType: null,
            targetType: targetType,
            title: shelf.title,
            pageInformation: this.metricsPageInformation,
            locationTracker: this.locationTracker,
            idType: idType,
        };
        metricsHelpersImpressions.addImpressionFields(objectGraph, shelf, options);
        this.sequenceId++;
    }
    /**
     * Reset the location tracker before creating the YMAL During Download shelf.
     * @param objectGraph The object graph.
     * @param shelfToken The shelf token being used to build the shelf.
     */
    static resetLocationTrackerForSimilarItemsDuringDownloadShelf(objectGraph, shelfToken) {
        // Reset the position of the location tracker, as it's based on the old position
        const locationTracker = shelfToken.sourceLocationTracker;
        metricsHelpersLocation.setCurrentPosition(locationTracker, 0);
        metricsHelpersLocation.currentLocation(locationTracker).id =
            ProductPageShelfMetrics.similarItemsDuringDownloadShelfId;
    }
    /**
     * Add impressions fields to the YMAL During Download shelf.
     * @param objectGraph The object graph.
     * @param shelf The created shelf to add impressions fields to.
     * @param shelfToken The shelf token used to build the shelf.
     */
    static addImpressionsFieldsToSimilarItemsDuringDownloadShelf(objectGraph, shelf, shelfToken) {
        if (!shelf) {
            return;
        }
        const options = {
            id: ProductPageShelfMetrics.similarItemsDuringDownloadShelfId,
            kind: null,
            softwareType: null,
            targetType: "similarItems",
            title: shelfToken.title,
            pageInformation: shelfToken.sourcePageInformation,
            locationTracker: shelfToken.sourceLocationTracker,
            idType: "relationship",
        };
        metricsHelpersImpressions.addImpressionFields(objectGraph, shelf, options);
    }
}
ProductPageShelfMetrics.similarItemsShelfId = "customers-also-bought-apps";
ProductPageShelfMetrics.similarItemsDuringDownloadShelfId = "customers-also-bought-apps-download";
//# sourceMappingURL=product-page-shelf-metrics.js.map