import { makeProductPageIntent as baseMakeProductPageIntent, } from "../../api/intents/product-page-intent";
import { makeAppEventPageIntent } from "../../api/intents/app-event-page-intent";
import { generateRoutes } from "../util/generate-routes";
import { makeSeeAllPageIntent, SEE_ALL_TYPES, } from "../../api/intents/see-all-page-intent";
import { Path } from "../../foundation/network/url-constants";
import { normalizePreviewPlaform } from "../../api/models/preview-platform";
/// MARK: Common Routing Definitions
const PRODUCT_PAGE_URL_PATTERN_WITH_APPNAME = "/app/{appName}/{id}";
const PRODUCT_PAGE_URL_PATTERN_WITHOUT_APPNAME = "/app/{id}";
const PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS = {
    optionalQuery: ["platform", "ppid", "lic"],
};
function makeProductPageIntent(opts) {
    const { ...clone } = opts;
    // The `{appName}` dynamic segment is part of the URL for SEO purposes, but is not actually part
    // of the `Intent` since it is not necessary for data-fetching. This data must not end up as
    // part of the `Intent` as the value cannot be consistently normalized, which can break important
    // caching behavior within the `web` client
    delete clone["appName"];
    return baseMakeProductPageIntent(clone);
}
const { routes: productPageRoutesWithAppNameSlug } = generateRoutes(
// @ts-expect-error `generateRoutes` does not handle a typed `Platform` value correctly
makeProductPageIntent, PRODUCT_PAGE_URL_PATTERN_WITH_APPNAME, [], PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS);
const { routes: productPageRoutesWithoutAppNameSlug, makeCanonicalUrl: makeProductPageURLWithoutAppSlug } = generateRoutes(baseMakeProductPageIntent, PRODUCT_PAGE_URL_PATTERN_WITHOUT_APPNAME, [], 
// @ts-expect-error `generateRoutes` does not handle a typed `Platform` value correctly
PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS);
// If an "App Clip Demo" URL is hit, we redirect to the product page via the setting of the `canonicalUrl` on `page`
const { routes: appClipDemoPageRoutes } = generateRoutes(
// @ts-expect-error `generateRoutes` does not handle a typed `Platform` value correctly
makeProductPageIntent, "/demo/{id}", [], PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS);
export const productPageRoutes = (objectGraph) => [
    ...productPageRoutesWithAppNameSlug(objectGraph),
    ...productPageRoutesWithoutAppNameSlug(objectGraph),
    ...appClipDemoPageRoutes(objectGraph),
];
export { makeProductPageURLWithoutAppSlug };
function makeAppEventPageIntentFromURLParams(options) {
    const { eventid: id, platform, storefront, language } = options;
    return makeAppEventPageIntent({
        storefront,
        language,
        platform,
        id,
    });
}
const { routes: appEventPageRoutesWithAppNameSlug } = generateRoutes(
// @ts-expect-error working around type-safety issues in `generateRoutes`
makeAppEventPageIntentFromURLParams, PRODUCT_PAGE_URL_PATTERN_WITH_APPNAME, ["eventid"], PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS);
const { routes: appEventPageRoutesWithoutAppNameSlug } = generateRoutes(
// @ts-expect-error working around type-safety issues in `generateRoutes`
makeAppEventPageIntentFromURLParams, PRODUCT_PAGE_URL_PATTERN_WITHOUT_APPNAME, ["eventid"], PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS);
export const appEventPageRoutes = (objectGraph) => [
    ...appEventPageRoutesWithAppNameSlug(objectGraph),
    ...appEventPageRoutesWithoutAppNameSlug(objectGraph),
];
function makeSeeAllPageIntentFromURL(params) {
    const { id, storefront, language, platform } = params;
    return makeSeeAllPageIntent({
        id,
        storefront,
        language,
        "platform": normalizePreviewPlaform(platform),
        "see-all": params["see-all"],
    });
}
const optionalQueryRuleParams = PRODUCT_PAGE_OPTIONAL_QUERY_PARAMS.optionalQuery.map((p) => `${p}?`);
const allSeeAllRules = [];
SEE_ALL_TYPES.forEach((seeAllType) => {
    const queryWithSeeAll = [`see-all=${seeAllType}`, ...optionalQueryRuleParams];
    [PRODUCT_PAGE_URL_PATTERN_WITH_APPNAME, PRODUCT_PAGE_URL_PATTERN_WITHOUT_APPNAME].forEach((pattern) => {
        allSeeAllRules.push({ path: pattern, query: queryWithSeeAll });
        allSeeAllRules.push({ path: `/{${Path.storeFront}}${pattern}`, query: queryWithSeeAll });
    });
});
const { routes: seeAllPageRoutes, makeCanonicalUrl: makeSeeAllPageURL } = generateRoutes(makeSeeAllPageIntentFromURL, PRODUCT_PAGE_URL_PATTERN_WITHOUT_APPNAME, ["see-all"], {
    extraRules: allSeeAllRules,
    optionalQuery: ["platform"],
});
export { seeAllPageRoutes, makeSeeAllPageURL };
//# sourceMappingURL=intent-controller-routing.js.map