import { defaultAdditionalPlatformsForClient, Request } from "../../foundation/media/data-fetching";
/**
 * Generates a {@linkcode Request} to the `app-bundles` Media API endpoint
 */
export function makeBundlePageRequest(objectGraph, intent) {
    const mediaApiRequest = new Request(objectGraph)
        .withIdOfType(intent.id, "app-bundles")
        .includingAdditionalPlatforms(defaultAdditionalPlatformsForClient(objectGraph))
        .includingRelationships(["genres", "developer", "apps", "developer-other-apps", "reviews"]);
    if (objectGraph.client.isWeb) {
        // Ensure that the "web" client fully hydrates all PDP shelves
        mediaApiRequest.addingQuery("sparseLimit[developer-other-apps]", "15");
        if (objectGraph.bag.enableUpdatedAgeRatings) {
            mediaApiRequest.includingAttributes(["ageRating"]);
        }
    }
    return mediaApiRequest;
}
//# sourceMappingURL=bundle-page-common.js.map