import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as content from "../../content/content";
import * as sad from "../../content/sad";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    // rdar://63384336 (Size should not appear in SAD apps)
    if (sad.systemApps(objectGraph).isSystemAppFromData(data)) {
        return null;
    }
    const combinedFileSize = content.combinedFileSizeFromData(objectGraph, data);
    if (serverData.isNull(combinedFileSize) || serverData.isNull(combinedFileSize.fileSizeByDevice)) {
        return null;
    }
    const fileSizeAndUnit = content.fileSizeAndUnitFromCombinedFileSize(objectGraph, combinedFileSize);
    if (!fileSizeAndUnit) {
        return null;
    }
    const badgeContent = {
        paragraphText: fileSizeAndUnit.size,
    };
    const caption = fileSizeAndUnit.unit;
    const heading = objectGraph.loc.string("BADGE_SIZE_HEADING");
    return new models.Badge("paragraph", "size", badgeContent, "standard", heading, caption, null, null, caption, "view");
}
//# sourceMappingURL=size-badge.js.map