import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../foundation/media/attributes";
import * as productPageUtil from "../product-page-util";
import * as reviews from "../reviews";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    // Only show this badge for the ribbon if:
    //  - the property "ribbonReviewBadge" is enabled (YukonC+)
    //  - all TV clients (at the time of writing, `embeddedInRibbon` is always `false` for tv, but we have this check here incase that ever changes).
    if (embeddedInRibbon && objectGraph.host.isWatch) {
        return null;
    }
    const userRating = mediaAttributes.attributeAsDictionary(data, "userRating");
    let badge = null;
    const shouldSuppressReviews = reviews.shouldSuppressReviews(objectGraph, data);
    if (!shouldSuppressReviews && userRating && userRating.value && userRating.ratingCount) {
        const userRatingValue = serverData.asNumber(userRating, "value");
        const roundedRatingValue = Math.round(userRatingValue * 10) / 10;
        const ratingFormatted = objectGraph.loc.decimal(roundedRatingValue, 1);
        const ratingCount = serverData.asNumber(userRating, "ratingCount");
        const ratingCountFormatted = objectGraph.loc.formattedCount(ratingCount);
        let caption;
        if (objectGraph.client.isVision || preprocessor.GAMES_TARGET) {
            caption = ratingCountFormatted;
        }
        else {
            caption = objectGraph.loc
                .stringWithCount("ProductPage.BadgeRating.Caption.ShortTemplate", ratingCount)
                .replace("{count}", ratingCountFormatted);
        }
        const longCaption = objectGraph.loc
            .stringWithCount("ProductPage.BadgeRating.Caption.LongTemplate", ratingCount)
            .replace("{count}", ratingCountFormatted)
            .replace("{rating}", ratingFormatted);
        const accessibilityTitle = objectGraph.loc
            .string("PRODUCT_ACCESSIBILITY_BADGE_STAR_RATING")
            .replace("{starCount}", ratingFormatted);
        badge = new models.Badge("rating", "rating", {
            rating: roundedRatingValue,
            ratingFormatted: ratingFormatted,
        }, "standard", caption, caption, longCaption, accessibilityTitle, caption);
    }
    else {
        // Prevent this item from appearing in the ribbon if there are not enough ratings.
        if (embeddedInRibbon) {
            return null;
        }
        const noRatingsCaption = objectGraph.loc.string("BADGE_NO_RATINGS_CAPTION");
        if (shouldSuppressReviews && noRatingsCaption !== "BADGE_NO_RATINGS_CAPTION") {
            badge = new models.Badge("rating", "rating", {}, "standard", null, noRatingsCaption, null, noRatingsCaption);
        }
        else if (!shouldSuppressReviews) {
            const caption = objectGraph.loc.string("BADGE_NOT_ENOUGH_RATINGS_CAPTION");
            badge = new models.Badge("rating", "rating", {}, "standard", null, caption, null, caption);
        }
    }
    if (badge) {
        let shelfBasedPageScrollAction;
        if (objectGraph.client.isVision) {
            shelfBasedPageScrollAction = new models.ShelfBasedPageScrollAction("productRatings", "notPurchasedRatingsAndReviews", "purchasedRatingsAndReviews", data.id);
        }
        else {
            shelfBasedPageScrollAction = new models.ShelfBasedPageScrollAction("productRatings");
        }
        badge.clickAction = productPageUtil.isShelfBased(objectGraph)
            ? shelfBasedPageScrollAction
            : new models.ProductPageScrollAction(new models.ProductPageSection("shelf", "reviews"));
        return badge;
    }
    return null;
}
//# sourceMappingURL=rating-badge.js.map