import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as contentAttributes from "../../content/attributes";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    if (objectGraph.host.isWatch) {
        return null;
    }
    const minPlayers = contentAttributes.contentAttributeAsNumber(objectGraph, data, "minPlayers");
    const maxPlayers = contentAttributes.contentAttributeAsNumber(objectGraph, data, "maxPlayers");
    if (!serverData.isDefinedNonNull(minPlayers) || !serverData.isDefinedNonNull(maxPlayers)) {
        return null;
    }
    // This can happen if the data is empty or corrupt.
    if (minPlayers <= 0 || maxPlayers <= 0 || minPlayers > maxPlayers) {
        return null;
    }
    const heading = objectGraph.loc.string("BADGE_PLAYERS_HEADING");
    const caption = multiplayerBadgeCaptionText(objectGraph, minPlayers, maxPlayers, false);
    const accessibilityHeading = multiplayerBadgeCaptionText(objectGraph, minPlayers, maxPlayers, true);
    const accessibilityCaption = objectGraph.loc.string("BADGE_PLAYERS_HEADING");
    const badgeContent = {
        paragraphText: multiplayerBadgeParagraphText(objectGraph, minPlayers, maxPlayers),
    };
    const style = objectGraph.client.isTV ? "annotation" : "standard";
    return new models.Badge("paragraph", "multiplayer", badgeContent, style, heading, caption, null, accessibilityHeading, accessibilityCaption, "view");
}
export function multiplayerBadgeParagraphText(objectGraph, minPlayers, maxPlayers) {
    const maxPlayersToShow = 32;
    if (minPlayers === maxPlayers) {
        if (minPlayers <= maxPlayersToShow) {
            return objectGraph.loc.formattedCount(minPlayers);
        }
        return objectGraph.loc
            .string("BADGE_PLAYERS_CAPTION_MULTIPLAYER_INDEFINITE_MIN_AND_MAX_LIMIT")
            .replace("{minPlayers}", objectGraph.loc.formattedCount(maxPlayersToShow));
    }
    if (maxPlayers <= maxPlayersToShow) {
        // This game can be single player, but also have up to 32 players
        return objectGraph.loc
            .string("BADGE_PLAYERS_CAPTION_MULTIPLAYER_DEFINITE_LIMIT")
            .replace("{minPlayers}", objectGraph.loc.formattedCount(minPlayers))
            .replace("{maxPlayers}", objectGraph.loc.formattedCount(maxPlayers));
    }
    // This game can be single player, but also have up to 32 players
    return objectGraph.loc
        .string("BADGE_PLAYERS_CAPTION_MULTIPLAYER_INDEFINITE_MAX_LIMIT")
        .replace("{minPlayers}", objectGraph.loc.formattedCount(minPlayers))
        .replace("{maxPlayers}", objectGraph.loc.formattedCount(maxPlayersToShow));
}
export function multiplayerBadgeCaptionText(objectGraph, minPlayers, maxPlayers, isAccessibilityCaption) {
    if (minPlayers === 1 && maxPlayers === 1) {
        return objectGraph.client.isVision
            ? objectGraph.loc.string("BADGE_PLAYERS_CAPTION_PLAYER")
            : objectGraph.loc.string("BADGE_PLAYERS_CAPTION_SINGLE");
    }
    if (minPlayers === 1 || isAccessibilityCaption) {
        return objectGraph.client.isVision
            ? objectGraph.loc.string("BADGE_PLAYERS_CAPTION_PLAYERS")
            : objectGraph.loc.string("BADGE_PLAYERS_CAPTION_MULTIPLAYER");
    }
    return objectGraph.loc.string("BADGE_PLAYERS_CAPTION_REQUIRED");
}
//# sourceMappingURL=multiplayer-badge.js.map