import * as models from "../../../api/models";
import * as contentAttributes from "../../content/attributes";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    if (objectGraph.client.isTV || objectGraph.client.isVision) {
        return null;
    }
    const isGameCenterEnabled = contentAttributes.contentAttributeAsBooleanOrFalse(objectGraph, data, "isGameCenterEnabled");
    if (!isGameCenterEnabled) {
        return null;
    }
    const heading = objectGraph.loc.string("BADGE_FRIENDS_HEADING", "Friends");
    const caption = "";
    const style = "standard";
    const badgeType = "friendsPlaying";
    const badgeKey = "friendsPlaying";
    const badgeContent = {
        maxNumberOfAvatarsToDisplay: 3,
        maxNumberOfFriendsBeforeTruncation: 99,
        adamId: data.id,
    };
    return new models.Badge(badgeType, badgeKey, badgeContent, style, heading, caption, null, caption, heading, "infer");
}
//# sourceMappingURL=friends-playing-badge.js.map