import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../foundation/media/attributes";
import { createArtworkForResource } from "../../content/artwork/artwork";
import { supportsVisionOSCompatibleIOSBinaryFromData } from "../../content/content";
import * as contentAttributes from "../../content/attributes";
import * as productPageUtil from "../product-page-util";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const supportsVisionOSCompatibleIOSBinary = supportsVisionOSCompatibleIOSBinaryFromData(objectGraph, data);
    if (supportsVisionOSCompatibleIOSBinary) {
        return null;
    }
    const editorialBadgeInfo = contentAttributes.contentAttributeAsDictionary(objectGraph, data, "editorialBadgeInfo");
    if (editorialBadgeInfo) {
        const badgeType = serverData.asString(editorialBadgeInfo, "editorialBadgeType");
        if (badgeType && badgeType === "editorialPriority") {
            if (objectGraph.client.isVision) {
                const caption = objectGraph.loc.string("EDITORS_CHOICE_SINGLE_LINE");
                const badge = new models.Badge("artwork", "editorsChoice", {}, "standard", null, caption, null, null, caption);
                badge.artwork = createArtworkForResource(objectGraph, "systemimage://laurel.leading");
                badge.trailingArtwork = createArtworkForResource(objectGraph, "systemimage://laurel.trailing");
                badge.clickAction = new models.ShelfBasedPageScrollAction("productRatings", "notPurchasedRatingsAndReviews", "purchasedRatingsAndReviews", data.id);
                return badge;
            }
            else {
                let caption;
                const genreNames = mediaAttributes.attributeAsArrayOrEmpty(data, "genreNames");
                if (genreNames[0] === "Games") {
                    caption = objectGraph.loc.string("EDITORIAL_BADGE_GAMES");
                }
                else {
                    caption = objectGraph.loc.string("EDITORIAL_BADGE_APPS");
                }
                let heading;
                if (embeddedInRibbon) {
                    heading = objectGraph.loc.string("EDITORS_CHOICE_RIBBON_HEADING");
                }
                else {
                    heading = objectGraph.loc.string("EDITORS_CHOICE_SINGLE_LINE");
                }
                const accessibilityTitle = objectGraph.loc.string("PRODUCT_ACCESSIBILITY_BADGE_EDITORS_CHOICE");
                const badge = new models.Badge("editorsChoice", "editorsChoice", {}, "standard", heading, caption, null, accessibilityTitle, caption);
                if (productPageUtil.isShelfBased(objectGraph)) {
                    badge.clickAction = new models.ShelfBasedPageScrollAction(objectGraph.client.isiOS ? "editorsChoice" : "productRatings");
                }
                else {
                    badge.clickAction = new models.ProductPageScrollAction(new models.ProductPageSection("shelf", "reviews"));
                }
                return badge;
            }
        }
    }
    return null;
}
//# sourceMappingURL=editors-choice-badge.js.map