import { isSome } from "@jet/environment/types/optional";
import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as contentAttributes from "../../content/attributes";
import * as content from "../../content/content";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const chartDataByStore = contentAttributes.contentAttributeAsDictionary(objectGraph, data, "chartPositions");
    if (chartDataByStore) {
        const storeChartKey = content.badgeChartKeyForClientIdentifier(objectGraph, objectGraph.host.clientIdentifier);
        if (storeChartKey) {
            const chartData = serverData.asDictionary(chartDataByStore, storeChartKey);
            if (chartData) {
                const position = serverData.asNumber(chartData, "position");
                const genreName = serverData.asString(chartData, "genreName");
                const genre = serverData.asString(chartData, "genre");
                const chart = serverData.asString(chartData, "chart");
                const heading = objectGraph.loc.string("BADGE_CHART_POSITION_HEADING");
                const accessibilityTitle = objectGraph.loc
                    .string("PRODUCT_ACCESSIBILITY_BADGE_CHART_POSITION_TITLE")
                    .replace("{chartPosition}", position.toString());
                const badge = new models.Badge("chartPosition", "chartPosition", {
                    position: objectGraph.loc.decimal(position),
                }, "standard", heading, genreName, null, accessibilityTitle, genreName, "view");
                const chartUrl = content.chartUrlFromData(objectGraph, genre, chart);
                // Charts are not currently supported for visionOS
                if (isSome(chartUrl) && !objectGraph.client.isVision) {
                    const action = new models.FlowAction("topCharts");
                    action.pageUrl = chartUrl;
                    badge.clickAction = action;
                }
                return badge;
            }
        }
    }
    return null;
}
//# sourceMappingURL=chart-badge.js.map