import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../foundation/media/attributes";
import { categoryArtworkData } from "../../categories";
import * as lockups from "../../lockups/lockups";
import * as badgesCommon from "./badges-common";
export function createBadge(objectGraph, data, embeddedInRibbon, metricsContext) {
    const categoryName = lockups.categoryFromData(objectGraph, data);
    if (serverData.isNullOrEmpty(categoryName)) {
        return null;
    }
    const badgeContent = {};
    const heading = objectGraph.loc.string("BADGE_CATEGORY_HEADING");
    const style = objectGraph.client.isTV ? "annotation" : "standard";
    const badgeType = objectGraph.client.isTV ? "custom" : "artwork";
    const badge = new models.Badge(badgeType, "category", badgeContent, style, heading, categoryName, null, categoryName, heading, "infer");
    const action = new models.FlowAction("page");
    action.title = mediaAttributes.attributeAsString(data, "artistName");
    if (embeddedInRibbon && objectGraph.client.deviceType !== "tv") {
        const artworkData = categoryArtworkData(objectGraph, data, true);
        // Artwork is required for artwork badges; if it's missing, hide the badge completely.
        if (badgeType === "artwork" && serverData.isNull(artworkData)) {
            return null;
        }
        badge.artwork = badgesCommon.badgeArtwork(objectGraph, artworkData, "bb");
    }
    return badge;
}
//# sourceMappingURL=category-badge.js.map