import { isDefinedNonNull } from "../../../foundation/json-parsing/server-data";
import { pageFieldsForPageInfoProductVariantData } from "../../product-page/product-page-variants";
import { EventLinter } from "../event-linter";
import * as metricsUtil from "./util";
// region Page Information
/**
 * Returns a set of pageFields from a given `pageInformation` - i.e. fields that are included on metrics data with `pageField` IncludingFields, and buyParams.
 * It is not recommended to use this function for instrumentation that involves field providers, as these page fields will overwrite them.
 * @param pageInformation Page information to create page fields for.
 */
export function fieldsFromPageInformation(pageInformation) {
    var _a;
    const fields = {};
    if (!pageInformation) {
        return fields;
    }
    Object.assign(fields, pageInformation.baseFields);
    if (pageInformation.pageUrl) {
        fields["pageUrl"] = pageInformation.pageUrl;
    }
    else if (pageInformation.timingMetrics && pageInformation.timingMetrics.pageURL) {
        fields["pageUrl"] = pageInformation.timingMetrics.pageURL;
    }
    if (pageInformation.recoMetricsData) {
        Object.assign(fields, pageInformation.recoMetricsData);
    }
    if (pageInformation.mercuryMetricsData) {
        Object.assign(fields, pageInformation.mercuryMetricsData);
    }
    if (pageInformation.productVariantData) {
        Object.assign(fields, pageFieldsForPageInfoProductVariantData(pageInformation.productVariantData));
    }
    if (pageInformation.iAdInfo && isDefinedNonNull(pageInformation.iAdInfo.pageFields[EventLinter.hasIAdData])) {
        fields[EventLinter.hasIAdData] = pageInformation.iAdInfo.pageFields[EventLinter.hasIAdData];
    }
    const iAdId = (_a = pageInformation.iAdInfo) === null || _a === void 0 ? void 0 : _a.pageFields["iAdId"];
    if (isDefinedNonNull(iAdId)) {
        fields["iAdId"] = iAdId;
    }
    return metricsUtil.sanitizedMetricsDictionary(fields);
}
// endregion
// region Network Performance
// @see `JSNetworkPerformanceMetrics.metrics(fromResult:)` in native.
// endregion
//# sourceMappingURL=misc.js.map