import { isNothing, isSome } from "@jet/environment";
import * as objects from "../../../foundation/util/objects";
import * as metricsBuilder from "../builder";
import * as metricsLocation from "./location";
import * as misc from "./misc";
import * as metricsUtil from "./util";
//* *************************
//* Media Metrics
//* *************************
export function addMetricsEventsToVideo(objectGraph, video, options) {
    if (isNothing(video)) {
        return;
    }
    const mediaEventFields = misc.fieldsFromPageInformation(options.pageInformation);
    if (mediaEventFields === null) {
        return;
    }
    mediaEventFields["id"] = metricsUtil.emptyStringIfNullOrUndefined(options.id);
    const idType = metricsUtil.idTypeForMetricsOptions(options);
    if (isSome(idType)) {
        mediaEventFields["idType"] = idType;
    }
    mediaEventFields["type"] = "video";
    mediaEventFields["typeDetails"] = "iTunesStoreContent";
    mediaEventFields["location"] = metricsLocation.createContentLocation(objectGraph, options, "");
    if (options.actionDetails) {
        mediaEventFields["actionDetails"] = options.actionDetails;
    }
    video.templateMediaEvent = metricsBuilder.createMetricsMediaData(objectGraph, mediaEventFields);
    const clickEventFields = objects.shallowCopyOf(mediaEventFields);
    clickEventFields["actionUrl"] = video.videoUrl;
    video.templateClickEvent = metricsBuilder.createMetricsMediaClickData(objectGraph, null, "button", clickEventFields);
}
//# sourceMappingURL=media.js.map