/**
 * Hack for injecting clientId and metrics data if needed.
 */
import { AppStoreMetricsData } from "../../../api/models";
/**
 * Opt out of legacy metrics id fields provider, the `AMSMetricsIdentifierFieldsProvider` instead
 * we'll rely solely on `MetricsIdFieldsProvider` added for Katana
 * @param objectGraph - The object graph.
 * @param metricsData - The metrics data.
 * @returns The metrics data, with the `amsMetricsID` field excluded.
 */
export function optOutOfLegacyMetricsIdFieldsProvider(objectGraph, metricsData) {
    var _a;
    const excludingFields = (_a = metricsData.excludingFields) !== null && _a !== void 0 ? _a : [];
    excludingFields.push("amsMetricsID");
    return new AppStoreMetricsData(metricsData.fields, metricsData.includingFields, excludingFields, metricsData.topic, metricsData.shouldFlush);
}
//# sourceMappingURL=legacy-metrics-identifier-fields-opt-out.js.map