//
//  hero-carousel-overlay-common.ts
//  AppStoreKit
//
//  Created by Jonathan Ellenbogen on 12/11/20.
//  Copyright (c) 2016 Apple Inc. All rights reserved.
//
import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import { artworkDictionaryFromData, videoDictionaryFromData } from "../../arcade/breakouts-common";
import * as content from "../../content/content";
export function heroArtworkFromData(objectGraph, data, presentedInTopShelf = false) {
    const artworkDictionary = artworkDictionaryFromData(objectGraph, data);
    const isPhone = objectGraph.client.isPhone;
    const isTV = objectGraph.client.isTV;
    let heroArtworkKey = isPhone ? "breakoutTall" : "breakoutFullScreen";
    if (presentedInTopShelf) {
        heroArtworkKey = "topShelf";
    }
    const heroArtworkData = serverData.asDictionary(artworkDictionary, heroArtworkKey);
    let heroArtwork = null;
    let backgroundColor = null;
    if (serverData.isDefinedNonNullNonEmpty(heroArtworkData)) {
        heroArtwork = content.artworkFromApiArtwork(objectGraph, heroArtworkData, {
            withJoeColorPlaceholder: true,
            useCase: 6 /* content.ArtworkUseCase.ArcadeLargeBreakout */,
        });
        if (serverData.isDefinedNonNullNonEmpty(heroArtwork)) {
            if (isPhone) {
                heroArtwork.crop = "oa";
            }
            else if (presentedInTopShelf) {
                heroArtwork.crop = "ta";
            }
            else if (isTV) {
                heroArtwork.crop = "od";
            }
            else {
                heroArtwork.crop = "ob";
            }
            backgroundColor = heroArtwork.backgroundColor;
        }
    }
    return {
        artwork: heroArtwork,
        artworkData: heroArtworkData,
        backgroundColor: backgroundColor,
    };
}
export function heroVideoFromData(objectGraph, data, isUpsell = false, wants9x16 = false) {
    const videoDictionary = videoDictionaryFromData(objectGraph, data);
    const use9x16 = objectGraph.client.isPhone || wants9x16;
    const heroVideoKey = use9x16 ? "sizzleVideo9x16" : "sizzleVideo16x9";
    const heroVideoFallbackKey = use9x16 ? "breakoutVideo9x16" : "breakoutVideo16x9";
    const heroVideoData = serverData.asDictionary(videoDictionary, heroVideoKey) ||
        serverData.asDictionary(videoDictionary, heroVideoFallbackKey);
    let heroVideo = null;
    let backgroundColor = null;
    let artworkData = null;
    if (serverData.isDefinedNonNullNonEmpty(heroVideoData)) {
        artworkData = serverData.asDictionary(heroVideoData, "previewFrame");
        const artwork = content.artworkFromApiArtwork(objectGraph, artworkData, {
            withJoeColorPlaceholder: true,
            useCase: 6 /* content.ArtworkUseCase.ArcadeLargeBreakout */,
        });
        if (serverData.isDefinedNonNullNonEmpty(artwork)) {
            artwork.crop = "sr";
            backgroundColor = artwork.backgroundColor;
        }
        // Get the video URL
        const videoUrl = serverData.asString(heroVideoData, "video");
        if (serverData.isDefinedNonNullNonEmpty(artwork) && (videoUrl === null || videoUrl === void 0 ? void 0 : videoUrl.length) > 0) {
            heroVideo = new models.Video(videoUrl, artwork, {
                canPlayFullScreen: false,
                allowsAutoPlay: true,
                looping: true,
                playbackControls: {
                    prominentPlay: isUpsell,
                },
                autoPlayPlaybackControls: {},
            });
        }
    }
    return {
        video: heroVideo,
        artworkData: artworkData,
        backgroundColor: backgroundColor,
    };
}
//# sourceMappingURL=hero-common.js.map