export const topChartFeaturedContentIds = new Set([
    117 /* FeaturedContentID.Common_iPhoneTopChart */,
    122 /* FeaturedContentID.Common_iPhonePaidTopChart */,
    118 /* FeaturedContentID.Common_iPhoneFreeTopChart */,
    195 /* FeaturedContentID.Common_iPadTopChart */,
    194 /* FeaturedContentID.Common_iPadFreeTopChart */,
    197 /* FeaturedContentID.Common_iPadPaidTopChart */,
    369 /* FeaturedContentID.AppStore_iPhoneFreeTopChartV2 */,
    370 /* FeaturedContentID.AppStore_iPhoneGrossingTopCharV2t */,
    371 /* FeaturedContentID.AppStore_iPadFreeTopChartV2 */,
    372 /* FeaturedContentID.AppStore_iPadGrossingTopChartV2 */,
    373 /* FeaturedContentID.AppStore_TVFreeTopChartV2 */,
    374 /* FeaturedContentID.AppStore_TVGrossingTopChartV2 */,
    375 /* FeaturedContentID.AppStore_WatchFreeTopChartV2 */,
    376 /* FeaturedContentID.AppStore_WatchGrossingTopChartV2 */,
    377 /* FeaturedContentID.AppStore_iPhonePaidTopChartV2 */,
    378 /* FeaturedContentID.AppStore_iPadPaidTopChartV2 */,
    379 /* FeaturedContentID.AppStore_TVPaidTopChartV2 */,
    380 /* FeaturedContentID.AppStore_WatchPaidTopChartV2 */,
    395 /* FeaturedContentID.AppStore_iPhoneiMessageFreeTopChart */,
    396 /* FeaturedContentID.AppStore_iPhoneiMessagePaidTopChart */,
    397 /* FeaturedContentID.AppStore_iPhoneiMessageGrossingTopChart */,
    398 /* FeaturedContentID.AppStore_iPadiMessageFreeTopChart */,
    399 /* FeaturedContentID.AppStore_iPadiMessagePaidTopChart */,
    400 /* FeaturedContentID.AppStore_iPadiMessageGrossingTopChart */,
    491 /* FeaturedContentID.AppStore_MacFreeTopChartV2 */,
    492 /* FeaturedContentID.AppStore_MacPaidTopChartV2 */,
    493 /* FeaturedContentID.AppStore_MacGrossingTopChartV2 */,
    504 /* FeaturedContentID.AppStore_SafariExtensionsFreeTopChartV2 */,
    505 /* FeaturedContentID.AppStore_SafariExtensionsPaidTopChartV2 */,
    506 /* FeaturedContentID.AppStore_SafariExtensionsGrossingTopChartV2 */,
    520 /* FeaturedContentID.AppStore_SafariExtensionsFreeTopChartV3_iPhone */,
    521 /* FeaturedContentID.AppStore_SafariExtensionsPaidTopChartV3_iPhone */,
    522 /* FeaturedContentID.AppStore_SafariExtensionsGrossingTopChartV3_iPhone */,
    523 /* FeaturedContentID.AppStore_SafariExtensionsFreeTopChartV3_iPad */,
    524 /* FeaturedContentID.AppStore_SafariExtensionsPaidTopChartV3_iPad */,
    525 /* FeaturedContentID.AppStore_SafariExtensionsGrossingTopChartV3_iPad */,
    530 /* FeaturedContentID.Arcade_iPadChartsV2 */,
    531 /* FeaturedContentID.Arcade_MacChartsV2 */,
    532 /* FeaturedContentID.Arcade_TVChartsV2 */,
    533 /* FeaturedContentID.Arcade_iPhoneChartsV2 */,
    567 /* FeaturedContentID.GameCenter_iPhoneTopCombinedChart */,
    571 /* FeaturedContentID.GameCenter_iPadTopCombinedChart */,
]);
const macTopChartFeaturedContentIds = new Set([
    491 /* FeaturedContentID.AppStore_MacFreeTopChartV2 */,
    492 /* FeaturedContentID.AppStore_MacPaidTopChartV2 */,
    493 /* FeaturedContentID.AppStore_MacGrossingTopChartV2 */,
]);
const arcadeTopChartFeaturedContentIds = new Set([
    530 /* FeaturedContentID.Arcade_iPadChartsV2 */,
    531 /* FeaturedContentID.Arcade_MacChartsV2 */,
    532 /* FeaturedContentID.Arcade_TVChartsV2 */,
    533 /* FeaturedContentID.Arcade_iPhoneChartsV2 */,
]);
/// Game Center top charts for iPhone and iPad
export const gameCenterTopChartFeaturedContentIds = new Set([
    567 /* FeaturedContentID.GameCenter_iPhoneTopCombinedChart */,
    571 /* FeaturedContentID.GameCenter_iPadTopCombinedChart */,
]);
export const recommendationsLockupShelfFeaturedContentIds = new Set([
    311 /* FeaturedContentID.Sundance_RecommendedAppsShelf */,
    312 /* FeaturedContentID.Sundance_RecommendedGamesShelf */,
    476 /* FeaturedContentID.AppStore_PersonalizedShelfMarker */,
]);
export const recommendationsShelfFeaturedContentIds = new Set([
    ...recommendationsLockupShelfFeaturedContentIds,
    518 /* FeaturedContentID.AppStore_PersonalizedAppEventsMarker */,
]);
export const lockupShelfFeaturedContentIds = new Set([
    557 /* FeaturedContentID.AppStore_CategoryBreakoutMarker */,
    418 /* FeaturedContentID.AppStore_Shelf */,
    431 /* FeaturedContentID.AppStore_iAPShelf */,
    429 /* FeaturedContentID.AppStore_ScreenShotShelf */,
    430 /* FeaturedContentID.AppStore_VideoShelf */,
    420 /* FeaturedContentID.AppStore_TrailerShelf */,
    304 /* FeaturedContentID.Sundance_iPhoneAppTrailerShelf */,
    305 /* FeaturedContentID.Sundance_iPadAppTrailerShelf */,
    260 /* FeaturedContentID.Sundance_Shelf */,
    497 /* FeaturedContentID.AppStore_ComingSoon */,
]);
const featuredContentIdsRequiringAdditionalTraversal = new Set([
    413 /* FeaturedContentID.AppStore_Root */,
    414 /* FeaturedContentID.AppStore_TabRoot */,
    254 /* FeaturedContentID.Sundance_Root */,
    255 /* FeaturedContentID.Sundance_TabRoot */,
    256 /* FeaturedContentID.Sundance_Stack */,
    266 /* FeaturedContentID.Sundance_QuickLinks */,
    271 /* FeaturedContentID.Sundance_TabSet */,
    436 /* FeaturedContentID.AppStore_DateBlock */,
]);
export function shouldContinueToWalkChildren(featuredContentId) {
    return featuredContentIdsRequiringAdditionalTraversal.has(featuredContentId);
}
export function isLockupShelf(featuredContentId) {
    return (isTopChart(featuredContentId) ||
        isRecommendationsShelf(featuredContentId) ||
        lockupShelfFeaturedContentIds.has(featuredContentId) ||
        featuredContentId === 518 /* FeaturedContentID.AppStore_PersonalizedAppEventsMarker */);
}
export function isRecommendationsLockupShelf(featuredContentId) {
    return recommendationsLockupShelfFeaturedContentIds.has(featuredContentId);
}
export function isRecommendationsShelf(featuredContentId) {
    return recommendationsShelfFeaturedContentIds.has(featuredContentId);
}
export function isMacTopChart(featuredContentId) {
    return macTopChartFeaturedContentIds.has(featuredContentId);
}
export function isTopChart(featuredContentId) {
    return topChartFeaturedContentIds.has(featuredContentId);
}
/// Game Center top charts are handled differently in some cases,
/// e.g. showing Game Center eyebrow
export function isGameCenterTopChart(featuredContentId) {
    return gameCenterTopChartFeaturedContentIds.has(featuredContentId);
}
/**
 * Arcade top charts are handled differently in some cases, eg. showing
 * a 'See All' button
 *
 * @param featuredContentId The kind of featured content
 * @returns Whether this is an Arcade Top Chart
 */
export function isArcadeTopChart(featuredContentId) {
    return arcadeTopChartFeaturedContentIds.has(featuredContentId);
}
//# sourceMappingURL=grouping-types.js.map