import * as serverData from "../../foundation/json-parsing/server-data";
import * as mediaDataStructure from "../../foundation/media/data-structure";
import { collectionShelfDisplayStyleFromShelfData } from "./editorial-data-util";
import { decorateCollectionShelfMetricsOptions } from "./editorial-page-shelf-builder/editorial-page-collection-shelf-builder";
import { decorateHeroShelfMetricsOptions } from "./editorial-page-shelf-builder/editorial-page-collection-shelf-builder/editorial-page-hero-collection-shelf-builder";
import { CollectionShelfDisplayStyle, EditorialShelfType } from "./editorial-page-types";
/**
 * Creates the shelf metrics options for a given shelf data item.
 * @param objectGraph Current object graph
 * @param shelfData The data for the shelf
 * @param title The metrics title for the shelf
 * @param metricsPageInformation Current metrics page information
 * @param metricsLocationTracker Current metrics location tracker
 * @returns Built shelf metrics options
 */
export function buildShelfMetricsOptions(objectGraph, shelfData, title, metricsPageInformation, metricsLocationTracker) {
    const shelfType = shelfData.type;
    const collectionDisplayStyle = collectionShelfDisplayStyleFromShelfData(objectGraph, shelfData);
    const shelfMetricsOptions = {
        id: serverData.asString(shelfData, "id"),
        kind: null,
        softwareType: null,
        targetType: "swoosh",
        title: title,
        pageInformation: metricsPageInformation,
        locationTracker: metricsLocationTracker,
        idType: "shelf_id",
        shelfType: shelfType,
        recoMetricsData: mediaDataStructure.metricsFromMediaApiObject(shelfData),
        canonicalId: serverData.asString(shelfData.meta, "canonicalId"),
    };
    switch (shelfType) {
        case EditorialShelfType.Collection:
            decorateCollectionShelfMetricsOptions(objectGraph, shelfData, shelfMetricsOptions);
            switch (collectionDisplayStyle) {
                case CollectionShelfDisplayStyle.Hero:
                    decorateHeroShelfMetricsOptions(objectGraph, shelfMetricsOptions);
                    break;
                default:
                    break;
            }
            break;
        case EditorialShelfType.Recommendations:
            decorateCollectionShelfMetricsOptions(objectGraph, shelfData, shelfMetricsOptions);
            break;
        default:
            break;
    }
    return shelfMetricsOptions;
}
//# sourceMappingURL=editorial-page-shelf-metrics.js.map