import { isNullOrEmpty } from "../../../foundation/json-parsing/server-data";
import { EditorialShelfType } from "../editorial-page-types";
import { buildChartShelf } from "./editorial-page-chart-shelf-builder";
import { buildCollectionShelf } from "./editorial-page-collection-shelf-builder";
import { buildEngagementShelf } from "./editorial-page-engagement-shelf-builder";
import { buildGameCenterShelf } from "./editorial-page-game-center-shelf-builder";
import { buildHeaderShelf } from "./editorial-page-header-shelf-builder";
import { buildImageShelf } from "./editorial-page-image-shelf-builder";
import { buildMarkerShelf } from "./editorial-page-marker-shelf-builder";
import { buildArcadeSeeAllGamesShelf } from "./editorial-page-arcade-see-all-games-shelf-builder";
import { buildRecommendationsShelf } from "./editorial-page-recommendations-shelf-builder";
import { buildTagShelf } from "./editorial-page-tag-shelf-builder";
import { buildTextShelf } from "./editorial-page-text-shelf-builder";
import { buildUpsellShelf } from "./editorial-page-upsell-shelf-builder";
import { buildVideoClipShelf } from "./editorial-page-video-clip-shelf-builder";
import { nextPosition, popLocation, pushContentLocation } from "../../metrics/helpers/location";
import { addImpressionFields } from "../../metrics/helpers/impressions";
import { storePlaceholderShelfImpressionMetrics } from "./editorial-page-collection-shelf-builder/editorial-page-collection-shelf-common";
import { isSome } from "@jet/environment/types/optional";
export function buildEditorialShelf(objectGraph, pageData, shelfToken) {
    let shelf = null;
    if (shelfToken.isFirstRender) {
        pushContentLocation(objectGraph, shelfToken.metricsImpressionOptions, shelfToken.title);
    }
    switch (shelfToken.type) {
        case EditorialShelfType.ArcadeSeeAllGames:
            shelf = buildArcadeSeeAllGamesShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Collection:
            shelf = buildCollectionShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Chart:
            shelf = buildChartShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Tag:
            shelf = buildTagShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Engagement:
            shelf = buildEngagementShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Text:
            shelf = buildTextShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Image:
            shelf = buildImageShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.VideoClip:
            shelf = buildVideoClipShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Header:
            shelf = buildHeaderShelf(objectGraph, pageData, shelfToken);
            break;
        case EditorialShelfType.Recommendations:
            shelf = buildRecommendationsShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.GameCenter:
            shelf = buildGameCenterShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Upsell:
            shelf = buildUpsellShelf(objectGraph, shelfToken);
            break;
        case EditorialShelfType.Marker:
            shelf = buildMarkerShelf(objectGraph, shelfToken);
            break;
        default:
            break;
    }
    if (isNullOrEmpty(shelf === null || shelf === void 0 ? void 0 : shelf.items) && isNullOrEmpty(shelf === null || shelf === void 0 ? void 0 : shelf.url)) {
        shelf = null;
    }
    if (shelfToken.isFirstRender) {
        popLocation(shelfToken.metricsImpressionOptions.locationTracker);
    }
    addImpressionFields(objectGraph, shelf, shelfToken.metricsImpressionOptions);
    if (shelfToken.isFirstRender) {
        nextPosition(shelfToken.metricsImpressionOptions.locationTracker);
    }
    if (isSome(shelf)) {
        storePlaceholderShelfImpressionMetrics(objectGraph, shelf, shelfToken);
    }
    return shelf;
}
//# sourceMappingURL=index.js.map