import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as arcadeCommon from "../../arcade/arcade-common";
import * as arcadeUpsell from "../../arcade/arcade-upsell";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
import * as metricsHelpersUtil from "../../metrics/helpers/util";
import { makeGamesPageUpsellHeaderFromData } from "../../../gameservicesui/src/editorial-page/editorial-component-builder";
export function buildUpsellShelf(objectGraph, shelfToken) {
    if (preprocessor.GAMES_TARGET) {
        return makeGamesPageUpsellHeaderFromData(objectGraph, shelfToken);
    }
    const upsellData = arcadeCommon.upsellFromRelationshipOf(objectGraph, shelfToken.data);
    if (serverData.isNullOrEmpty(upsellData)) {
        return null;
    }
    const marketingItemData = upsellData.marketingItemData;
    if (serverData.isNullOrEmpty(marketingItemData) || serverData.isNullOrEmpty(marketingItemData.attributes)) {
        return null;
    }
    const metricsOptions = {
        pageInformation: shelfToken.metricsPageInformation,
        locationTracker: shelfToken.metricsLocationTracker,
        mercuryMetricsData: metricsHelpersUtil.marketingItemTopLevelBaseFieldsFromData(objectGraph, marketingItemData),
    };
    const upsellBreakout = arcadeUpsell.createUpsellBreakout(objectGraph, marketingItemData, metricsOptions);
    metricsHelpersLocation.nextPosition(shelfToken.metricsLocationTracker);
    const shelf = new models.Shelf("upsellBreakout");
    shelf.items = [upsellBreakout];
    return shelf;
}
//# sourceMappingURL=editorial-page-upsell-shelf-builder.js.map