import * as serverData from "../../../../foundation/json-parsing/server-data";
import { attributeAsString } from "../../../../foundation/media/attributes";
import { MarkerShelfKind } from "../../editorial-page-types";
import { buildQuickLinksShelf } from "./editorial-page-quick-links-marker-shelf-builder";
export function buildMarkerShelf(objectGraph, shelfToken) {
    const markerKind = attributeAsString(shelfToken.data, "kind");
    if (serverData.isNullOrEmpty(markerKind)) {
        return null;
    }
    let shelf = null;
    switch (markerKind) {
        case MarkerShelfKind.QuickLinks:
            shelf = buildQuickLinksShelf(objectGraph, shelfToken);
            break;
        default:
            break;
    }
    return shelf;
}
//# sourceMappingURL=index.js.map