import * as models from "../../../../api/models";
import * as serverData from "../../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import * as metricsHelpersLocation from "../../../metrics/helpers/location";
import * as editorialActionUtil from "../../editorial-action-util";
import * as editorialDataUtil from "../../editorial-data-util";
import * as editorialCopyUtil from "../../editorial-page-editorial-copy-util";
import { CollectionShelfLayoutDirection } from "../../editorial-page-types";
import { createShelfTokenUrlIfNecessary, shouldDefer } from "./editorial-page-collection-shelf-common";
import * as metricsHelpersImpressions from "../../../metrics/helpers/impressions";
import { insertPlaceholdersIntoShelfIfRequired } from "../../../placeholders/placeholders";
export function buildTextOnlyShelf(objectGraph, shelfToken) {
    var _a;
    const items = [];
    const shelf = new models.Shelf("action");
    shelf.isHorizontal =
        mediaAttributes.attributeAsString(shelfToken.data, "layoutDirection") ===
            CollectionShelfLayoutDirection.Horizontal;
    const shelfContents = editorialDataUtil.extractRemainingItemsOrInitialShelfContents(objectGraph, shelfToken);
    for (const itemData of shelfContents) {
        if (serverData.isNull(itemData.attributes) || shouldDefer(shelfToken)) {
            shelfToken.isDeferring = true;
            shelfToken.remainingItems.push(itemData);
            continue;
        }
        const action = editorialActionUtil.createPrimaryActionForComponentFromData(objectGraph, itemData, shelfToken);
        action.title = editorialCopyUtil.editorialTitleFromData(objectGraph, itemData, shelfToken.collectionDisplayStyle);
        // Configure impressions
        const contentMetricsOptions = {
            ...shelfToken.metricsImpressionOptions,
            id: itemData.id,
            idType: "editorial_id",
            targetType: "textOnly",
        };
        const impressionOptions = metricsHelpersImpressions.impressionOptions(objectGraph, itemData, action.title, contentMetricsOptions);
        metricsHelpersImpressions.addImpressionFields(objectGraph, action, impressionOptions);
        if (action.isValid()) {
            items.push(action);
            metricsHelpersLocation.nextPosition(shelfToken.metricsImpressionOptions.locationTracker);
        }
    }
    // We don't need this in our incomplete shelf URL, so we'll preemptively remove it.
    delete shelfToken.maxItemCount;
    shelf.eyebrow = shelfToken.eyebrow;
    shelf.eyebrowArtwork = shelfToken.eyebrowArtwork;
    shelf.title = shelfToken.title;
    shelf.subtitle = shelfToken.subtitle;
    shelf.items = items;
    shelf.rowsPerColumn = (_a = mediaAttributes.attributeAsNumber(shelfToken.data, "rowCount")) !== null && _a !== void 0 ? _a : 1;
    shelf.url = createShelfTokenUrlIfNecessary(objectGraph, shelf, shelfToken);
    insertPlaceholdersIntoShelfIfRequired(objectGraph, shelf, shelfToken);
    return shelf;
}
//# sourceMappingURL=editorial-page-text-only-collection-shelf-builder.js.map