import * as models from "../../../../api/models";
import { isNull } from "../../../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../../../foundation/media/attributes";
import * as mediaDataStructure from "../../../../foundation/media/data-structure";
import * as metricsHelpersLocation from "../../../metrics/helpers/location";
import { insertPlaceholdersIntoShelfIfRequired } from "../../../placeholders/placeholders";
import { clickTargetForCollectionDisplayStyle } from "../../editorial-action-util";
import * as editorialDataUtil from "../../editorial-data-util";
import * as editorialMediaUtil from "../../editorial-media-util";
import { CollectionShelfDisplayStyle, collectionShelfLayoutDirection } from "../../editorial-page-types";
import { createShelfTokenUrlIfNecessary, shouldDefer } from "./editorial-page-collection-shelf-common";
import { buildStoryCard } from "./editorial-page-story-card-utils";
import * as gamesComponentBuilder from "../../../../gameservicesui/src/editorial-page/editorial-component-builder";
import { isSome } from "@jet/environment/types/optional";
export function buildSmallStoryCardShelf(objectGraph, shelfToken) {
    return buildStoryCardShelf(objectGraph, shelfToken, CollectionShelfDisplayStyle.StorySmall, "smallStoryCard");
}
export function buildMediumStoryCardShelf(objectGraph, shelfToken) {
    return buildStoryCardShelf(objectGraph, shelfToken, CollectionShelfDisplayStyle.StoryMedium, "mediumStoryCard");
}
function buildStoryCardShelf(objectGraph, shelfToken, displayStyle, storyComponentType) {
    const items = [];
    const shelf = new models.Shelf(storyComponentType);
    const layoutDirection = collectionShelfLayoutDirection(shelfToken);
    shelf.isHorizontal = layoutDirection === "Horizontal";
    const shelfContents = editorialDataUtil.extractRemainingItemsOrInitialShelfContents(objectGraph, shelfToken);
    for (const itemData of shelfContents) {
        const metricsOptions = {
            ...shelfToken.metricsImpressionOptions,
            targetType: clickTargetForCollectionDisplayStyle(objectGraph, displayStyle),
            recoMetricsData: mediaDataStructure.metricsFromMediaApiObject(itemData),
        };
        if (!mediaAttributes.hasAttributes(itemData) || shouldDefer(shelfToken)) {
            shelfToken.remainingItems.push(itemData);
            shelfToken.isDeferring = true;
            continue;
        }
        let storyCard = null;
        if (preprocessor.GAMES_TARGET && gamesComponentBuilder.shouldUseMediaCard(displayStyle)) {
            storyCard = gamesComponentBuilder.makeEditorialMediaCard(objectGraph, itemData, "Card", shelfToken, "Editorial");
        }
        else {
            storyCard = buildStoryCard(objectGraph, itemData, editorialMediaUtil.EditorialMediaPlacement.StoryCard, metricsOptions, shelfToken.collectionDisplayStyle, true, shelfToken);
        }
        if (isNull(storyCard)) {
            continue;
        }
        items.push(storyCard);
        metricsHelpersLocation.nextPosition(shelfToken.metricsImpressionOptions.locationTracker);
    }
    // We don't need this in our incomplete shelf URL, so we'll preemptively remove it.
    delete shelfToken.maxItemCount;
    shelf.eyebrow = shelfToken.eyebrow;
    shelf.eyebrowArtwork = shelfToken.eyebrowArtwork;
    shelf.title = shelfToken.title;
    shelf.subtitle = shelfToken.subtitle;
    if (preprocessor.GAMES_TARGET &&
        gamesComponentBuilder.shouldUseComponentGrid(displayStyle, layoutDirection, shelfToken)) {
        const item = gamesComponentBuilder.makeComponentGrid(objectGraph, items, shelfToken, displayStyle);
        shelf.items = isSome(item) ? [item] : [];
    }
    else {
        shelf.items = items;
    }
    shelf.rowsPerColumn = mediaAttributes.attributeAsNumber(shelfToken.data, "rowCount");
    shelf.url = createShelfTokenUrlIfNecessary(objectGraph, shelf, shelfToken);
    insertPlaceholdersIntoShelfIfRequired(objectGraph, shelf, shelfToken);
    return shelf;
}
//# sourceMappingURL=editorial-page-story-card-collection-shelf-builder.js.map