import * as arcadeCommon from "../../arcade/arcade-common";
import * as color from "../../../foundation/util/color-util";
import * as content from "../../content/content";
import * as editorialDataUtil from "../editorial-data-util";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as gamesComponentBuilder from "../../../gameservicesui/src/editorial-page/editorial-component-builder";
export function buildArcadeSeeAllGamesShelf(objectGraph, shelfToken) {
    const footer = new models.ArcadeFooter();
    const shelf = new models.Shelf("arcadeFooter");
    shelf.items = [footer];
    const impressionOptions = {
        targetType: "arcadeSeeAllGamesFooter",
        pageInformation: shelfToken.metricsPageInformation,
        locationTracker: shelfToken.metricsLocationTracker,
        title: objectGraph.loc.string("Arcade.SeeAllGames.Button.Title"),
        id: shelfToken.id,
        kind: "footer",
        softwareType: "Arcade",
    };
    metricsHelpersImpressions.addImpressionFields(objectGraph, footer, impressionOptions);
    metricsHelpersLocation.pushContentLocation(objectGraph, impressionOptions, impressionOptions.title);
    if (preprocessor.GAMES_TARGET) {
        footer.buttonAction = gamesComponentBuilder.makeArcadeSeeAllAction(objectGraph);
    }
    else {
        footer.buttonAction = arcadeCommon.seeAllArcadeGamesPageFlowAction(objectGraph, "releaseDate", shelfToken.metricsPageInformation, shelfToken.metricsLocationTracker);
    }
    const buttonImpressionOptions = {
        targetType: "button",
        pageInformation: shelfToken.metricsPageInformation,
        locationTracker: shelfToken.metricsLocationTracker,
        title: footer.buttonAction.title,
        id: "SeeAllGames",
        kind: "button",
        softwareType: "Arcade",
    };
    metricsHelpersImpressions.addImpressionFields(objectGraph, footer.buttonAction, buttonImpressionOptions);
    metricsHelpersLocation.popLocation(impressionOptions.locationTracker);
    const termsAndConditionsUrl = objectGraph.bag.termsAndConditionsURL;
    const shouldAddTermsAndConditions = !serverData.isNull(termsAndConditionsUrl) && objectGraph.client.deviceType !== "tv";
    if (shouldAddTermsAndConditions) {
        const termsAndConditionTitle = objectGraph.loc.string("TermsAndConditions.Title");
        const urlAction = new models.ExternalUrlAction(termsAndConditionsUrl);
        const footnote = new models.Footnote(termsAndConditionTitle);
        footnote.clickAction = urlAction;
        footnote.presentationStyle = ["hasChevron", "textLightensOnHighlight", "hasSeparator"];
        footer.footnote = footnote;
    }
    shelf.background = {
        type: "color",
        color: color.named("placeholderBackground"),
    };
    const shelfContents = editorialDataUtil.extractRemainingItemsOrInitialShelfContents(objectGraph, shelfToken);
    if (serverData.isDefinedNonNullNonEmpty(shelfContents)) {
        const metricsOptions = {
            pageInformation: shelfToken.metricsPageInformation,
            locationTracker: shelfToken.metricsLocationTracker,
        };
        footer.icons = content.impressionableAppIconsFromDataCollection(objectGraph, shelfContents, metricsOptions, {
            useCase: 2 /* content.ArtworkUseCase.LockupIconMedium */,
        });
    }
    else {
        footer.icons = [];
    }
    return shelf;
}
//# sourceMappingURL=editorial-page-arcade-see-all-games-shelf-builder.js.map