import * as models from "../../../api/models";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as arcadeCommon from "../../arcade/arcade-common";
import * as lockups from "../../lockups/lockups";
export function buildArcadeLockup(objectGraph, upsellBreakoutShelfToken) {
    const metricsOptions = {
        pageInformation: upsellBreakoutShelfToken.metricsPageInformation,
        locationTracker: upsellBreakoutShelfToken.metricsLocationTracker,
    };
    const upsellData = arcadeCommon.upsellFromRelationshipOf(objectGraph, upsellBreakoutShelfToken.data);
    if (serverData.isNullOrEmpty(upsellData)) {
        return null;
    }
    const arcadeLockup = lockups.arcadeLockupFromData(objectGraph, upsellData, metricsOptions, models.marketingItemContextFromString("arcadeTabHeader"), "colored", objectGraph.client.isMac ? "arcade" : "navigationBar");
    return arcadeLockup;
}
//# sourceMappingURL=editorial-page-arcade-lockup-builder.js.map