import * as serverData from "../../foundation/json-parsing/server-data";
import { popLocation, pushBasicLocation } from "../metrics/helpers/location";
import * as editorialComponentMediaUtil from "./editorial-page-component-media-util";
export function extractOverlayContent(objectGraph, itemData, lockupOptions) {
    const overlayContent = {};
    pushBasicLocation(objectGraph, lockupOptions.metricsOptions, "collectionIcons");
    const collectionIcons = editorialComponentMediaUtil.editorialFallbackAppIconsFromData(objectGraph, itemData, lockupOptions);
    popLocation(lockupOptions.metricsOptions.locationTracker);
    const appLockup = editorialComponentMediaUtil.editorialAppLockupFromData(objectGraph, itemData, lockupOptions);
    if (serverData.isDefinedNonNullNonEmpty(collectionIcons) &&
        (collectionIcons.length > 1 || serverData.isNullOrEmpty(appLockup))) {
        overlayContent.collectionIcons = collectionIcons;
    }
    else if (serverData.isDefinedNonNull(appLockup)) {
        overlayContent.lockup = appLockup;
        overlayContent.collectionIcons = [appLockup.icon];
    }
    return overlayContent;
}
//# sourceMappingURL=editorial-page-overlay-content-util.js.map