import * as editorialPageControllerUtil from "./editorial-page-controller-util";
import { Request as MediaAPIRequest, defaultAdditionalPlatformsForClient } from "../../foundation/media/data-fetching";
import { Parameters } from "../../foundation/network/url-constants";
import { shouldFetchCustomAttributes } from "../product-page/product-page-variants";
import { isEditorialPageIntentByName, } from "../../api/intents/editorial/editorial-page-intent";
import { setPreviewPlatform } from "../preview-platform";
export function makeEditorialPageRequest(objectGraph, intent) {
    const mediaApiRequest = makeBaseMediaAPIRequest(objectGraph, intent);
    if (isEditorialPageIntentByName(intent)) {
        mediaApiRequest.addingQuery(Parameters.name, intent.name);
    }
    else {
        mediaApiRequest.withIdOfType(intent.id, "editorial-pages");
    }
    prepareMediaAPIRequest(objectGraph, mediaApiRequest);
    setPreviewPlatform(objectGraph, mediaApiRequest);
    return mediaApiRequest;
}
function makeBaseMediaAPIRequest(objectGraph, locale) {
    return new MediaAPIRequest(objectGraph, `/v1/editorial/${locale.storefront}`).forType("editorial-pages");
}
function prepareMediaAPIRequest(objectGraph, mediaApiRequest) {
    mediaApiRequest.includingAdditionalPlatforms(defaultAdditionalPlatformsForClient(objectGraph));
    mediaApiRequest.usingCustomAttributes(shouldFetchCustomAttributes(objectGraph));
    // <rdar://53420717> For performance reasons, we limit shelves to 3 items on watchOS.
    if (objectGraph.client.isWatch) {
        mediaApiRequest.addingRelationshipLimit("contents", 3);
    }
    mediaApiRequest
        .includingAgeRestrictions()
        .includingScopedRelationships("editorial-shelves", ["contents"])
        .includingScopedRelationships("editorial-pages", ["primary-contents"])
        .includingRelationships(["canvas"])
        .withSparseCount(editorialPageControllerUtil.pageSparseCount(objectGraph))
        .withSparseLimit(editorialPageControllerUtil.pageSparseLimit(objectGraph))
        .includingAssociateKeys("editorial-shelves-collection:contents", ["editorial-cards"]);
    editorialPageControllerUtil.prepareMAPIRequest(objectGraph, mediaApiRequest);
}
//# sourceMappingURL=editorial-page-media-api-utils.js.map