import { isSome } from "@jet/environment/types/optional";
import * as models from "../../api/models";
import * as serverData from "../../foundation/json-parsing/server-data";
import * as mediaAttributes from "../../foundation/media/attributes";
import * as mediaDataStructure from "../../foundation/media/data-structure";
import * as content from "../content/content";
import * as heroCarouselOverlayCommon from "../grouping/hero/hero-carousel-overlay-common";
import { deepLinkUrlFromData } from "../linking/external-deep-link";
import * as lockups from "../lockups/lockups";
import * as metricsHelpersImpressions from "../metrics/helpers/impressions";
import * as editorialComponentMediaUtil from "./editorial-page-component-media-util";
import * as editorialCopyUtil from "./editorial-page-editorial-copy-util";
import * as editorialOverlayContentUtil from "./editorial-page-overlay-content-util";
import { CollectionShelfDisplayStyle } from "./editorial-page-types";
// region Overlay
export function heroOverlayFromData(objectGraph, data, shelfToken, editorialClientParams) {
    const heroCarouselItemOverlay = new models.HeroCarouselItemOverlay();
    heroCarouselItemOverlay.overlayType = heroCarouselOverlayCommon.overlayTypeFromData(objectGraph, data);
    heroCarouselItemOverlay.displayOptions = {
        horizontalPlacement: "leading",
        textAlignment: "leading",
        isOverDarkContent: heroCarouselOverlayCommon.overlayIsOverDarkContent(objectGraph, data),
    };
    heroCarouselItemOverlay.badgeText = editorialCopyUtil.editorialBadgeFromData(objectGraph, data, CollectionShelfDisplayStyle.Hero);
    heroCarouselItemOverlay.titleText = editorialCopyUtil.editorialTitleFromData(objectGraph, data, CollectionShelfDisplayStyle.Hero);
    if (!editorialClientParams.suppressTagline) {
        heroCarouselItemOverlay.descriptionText = editorialCopyUtil.editorialDescriptionFromData(objectGraph, data, true);
    }
    heroCarouselItemOverlay.callToActionText = editorialCopyUtil.editorialCallToActionFromData(objectGraph, data);
    heroCarouselItemOverlay.buttonTitle = heroCarouselOverlayCommon.overlayButtonTitleFromData(objectGraph, data);
    const lockupOptions = {
        metricsOptions: {
            pageInformation: shelfToken.metricsPageInformation,
            locationTracker: shelfToken.metricsLocationTracker,
            targetType: "lockupSmall",
            recoMetricsData: mediaDataStructure.metricsFromMediaApiObject(data),
        },
        metricsClickOptions: {
            id: data.id,
            pageInformation: shelfToken.metricsPageInformation,
            locationTracker: shelfToken.metricsLocationTracker,
            actionDetails: {
                franchise: heroCarouselItemOverlay.badgeText,
            },
        },
        artworkUseCase: 1 /* content.ArtworkUseCase.LockupIconSmall */,
        offerEnvironment: "dark",
        canDisplayArcadeOfferButton: content.shelfDisplayStyleCanDisplayArcadeOfferButtons(objectGraph, shelfToken.collectionDisplayStyle),
        isContainedInPreorderExclusiveShelf: false,
        externalDeepLinkUrl: deepLinkUrlFromData(objectGraph, data),
    };
    const appLockup = editorialComponentMediaUtil.editorialAppLockupFromData(objectGraph, data, lockupOptions);
    const overlayContent = editorialOverlayContentUtil.extractOverlayContent(objectGraph, data, lockupOptions);
    heroCarouselItemOverlay.lockup = overlayContent.lockup;
    heroCarouselItemOverlay.collectionIcons = overlayContent.collectionIcons;
    // If this EI can and should show the expected release date of an arcade app, override the badge.
    const fallbackLabel = mediaAttributes.attributeAsString(data, "label");
    // For hero items the design is to use editorial labels instead of "Apple Arcade" so we replace that text here
    if (serverData.isDefinedNonNullNonEmpty(fallbackLabel) && serverData.isDefinedNonNull(appLockup)) {
        appLockup.heading = fallbackLabel;
    }
    const suppressLockup = isSome(editorialClientParams.suppressLockup) && editorialClientParams.suppressLockup;
    if (serverData.isDefinedNonNullNonEmpty(heroCarouselItemOverlay.lockup) && !suppressLockup) {
        heroCarouselItemOverlay.clickAction = heroCarouselItemOverlay.lockup.clickAction;
        heroCarouselItemOverlay.impressionMetrics = heroCarouselItemOverlay.lockup.impressionMetrics;
    }
    else {
        const heroCarouselItemOverlayMetricsOptions = {
            targetType: "hero",
            pageInformation: shelfToken.metricsPageInformation,
            locationTracker: shelfToken.metricsLocationTracker,
            recoMetricsData: mediaDataStructure.metricsFromMediaApiObject(data),
        };
        const heroCarouselOverlayItemClickOptions = {
            ...heroCarouselItemOverlayMetricsOptions,
            id: data.id,
            actionDetails: {
                franchise: heroCarouselItemOverlay.badgeText,
            },
        };
        heroCarouselItemOverlay.clickAction = lockups.editorialItemActionFromData(objectGraph, data, heroCarouselOverlayItemClickOptions, shelfToken.clientIdentifierOverride);
        const heroCarouselItemOverlayImpressionsOptions = metricsHelpersImpressions.impressionOptions(objectGraph, data, heroCarouselItemOverlay.titleText, heroCarouselItemOverlayMetricsOptions);
        metricsHelpersImpressions.addImpressionFields(objectGraph, heroCarouselItemOverlay, heroCarouselItemOverlayImpressionsOptions);
    }
    return heroCarouselItemOverlay;
}
// endregion
//# sourceMappingURL=editorial-page-hero-util.js.map