import * as lockups from "../lockups/lockups";
import { CollectionShelfDisplayStyle } from "./editorial-page-types";
/**
 * For a given piece of MAPI data create the primary clickAction for the component with this data
 * @param objectGraph
 * @param data
 * @param shelfToken
 */
export function createPrimaryActionForComponentFromData(objectGraph, data, shelfToken, baseClickOptions) {
    const clickOptions = createClickOptionsFromData(objectGraph, data, shelfToken, baseClickOptions);
    const primaryAction = lockups.actionFromData(objectGraph, data, clickOptions, shelfToken.clientIdentifierOverride);
    return primaryAction;
}
function createClickOptionsFromData(objectGraph, data, shelfToken, baseClickOptions) {
    const targetType = clickTargetForCollectionDisplayStyle(objectGraph, shelfToken.collectionDisplayStyle);
    const clickOptions = {
        ...shelfToken.metricsImpressionOptions,
        ...baseClickOptions,
        id: data.id,
        targetType: targetType,
    };
    return clickOptions;
}
export function clickTargetForCollectionDisplayStyle(objectGraph, displayStyle) {
    switch (displayStyle) {
        case CollectionShelfDisplayStyle.Hero:
            return "hero";
        case CollectionShelfDisplayStyle.TextOnly:
            return "textOnly";
        case CollectionShelfDisplayStyle.TextWithArtwork:
            return "textWithArtwork";
        case CollectionShelfDisplayStyle.BrickSmall:
            return "brickSmall";
        case CollectionShelfDisplayStyle.BrickMedium:
            return "brickMedium";
        case CollectionShelfDisplayStyle.BrickLarge:
            return "brickLarge";
        case CollectionShelfDisplayStyle.EditorialLockupMedium:
        case CollectionShelfDisplayStyle.EditorialLockupMediumVariant:
            return "editorialLockupMedium";
        case CollectionShelfDisplayStyle.EditorialLockupLarge:
        case CollectionShelfDisplayStyle.EditorialLockupLargeVariant:
            return "editorialLockupLarge";
        case CollectionShelfDisplayStyle.LockupSmall:
            return "lockupSmall";
        case CollectionShelfDisplayStyle.LockupLarge:
            return "lockupLarge";
        case CollectionShelfDisplayStyle.StorySmall:
            return "storySmall";
        case CollectionShelfDisplayStyle.StoryMedium:
            return "storyMedium";
        case CollectionShelfDisplayStyle.BreakoutLarge:
            return "largeBreakout";
        default:
            return "lockup";
    }
}
//# sourceMappingURL=editorial-action-util.js.map