/**
 * Created by keithpk on 1/25/17.
 */
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as artworkBuilder from "./artwork";
export function closestArtworkMatchingSize(objectGraph, artworkArray, width, height) {
    const desiredRatio = width / height;
    let foundAspectRatio = 0;
    let foundArtwork = null;
    for (const artwork of artworkArray) {
        const actualWidth = serverData.asNumber(artwork, "width");
        const actualHeight = serverData.asNumber(artwork, "height");
        const actualRatio = actualWidth / actualHeight;
        if (actualRatio === desiredRatio ||
            Math.abs(desiredRatio - actualRatio) <= Math.abs(desiredRatio - foundAspectRatio)) {
            if (!foundArtwork ||
                (actualWidth <= width && actualWidth > foundArtwork.width) ||
                (foundArtwork.width > width && actualWidth < foundArtwork.width && actualWidth > foundArtwork.width)) {
                foundArtwork = artwork;
                foundAspectRatio = actualRatio;
            }
        }
    }
    if (foundArtwork) {
        const artworkUrl = serverData.asString(foundArtwork, "url");
        const foundWidth = serverData.asNumber(foundArtwork, "width");
        const foundHeight = serverData.asNumber(foundArtwork, "height");
        const foundChecksum = serverData.asString(foundArtwork, "checksum");
        return artworkBuilder.createArtworkForResource(objectGraph, artworkUrl, foundWidth, foundHeight, null, null, foundChecksum);
    }
    return null;
}
//# sourceMappingURL=legacy-artwork.js.map