/**
 * Created by km on 10/5/16.
 */
/// The suggested maximum items to load per page.
export const suggestedMaxPerPage = 20;
/**
 * Returns a single page of lookup data from a page token.
 * @param pageToken The page token to extract the ids from.
 * @returns An array of zero or more ids to lookup.
 */
export function getDataForLookup(objectGraph, pageToken) {
    if (!pageToken || !pageToken.remainingContent) {
        return [];
    }
    return pageToken.remainingContent.slice(0, pageToken.maxPerPage);
}
/**
 * Returns a page token containing the ids to fetch for the next page of data.
 * @param pageToken The page token to advance.
 * @param count The number of items to get, or all items if not specified
 * @returns A new page token.
 */
export function nextPageToken(objectGraph, pageToken, count) {
    const nextToken = { ...pageToken };
    if (pageToken && pageToken.remainingContent) {
        const nextContent = nextDataRange(objectGraph, pageToken.remainingContent, pageToken.maxPerPage, count);
        nextToken.remainingContent = nextContent;
    }
    return nextToken;
}
/**
 * Returns a subset of the content from start to the end of the array
 * @param ids The array of IDs from which to get the sub array
 * @param start The starting index
 * @param count The number of items to get, or all items if not specified
 * @returns An array of all ids from start until the end of the array
 */
export function nextDataRange(objectGraph, dataArray, start, count) {
    return dataArray.slice(start, count !== null && count !== void 0 ? count : dataArray.length);
}
export function createMediaPageToken(objectGraph, remaining, url, nextHref = null, pageInformation, locationTracker) {
    return {
        remainingContent: remaining,
        maxPerPage: suggestedMaxPerPage,
        highestOrdinal: 0,
        url: url,
        metricsPageInformation: pageInformation,
        metricsLocationTracker: locationTracker,
    };
}
//# sourceMappingURL=pagination.js.map