import { isNothing } from "@jet/environment";
import { allMixed } from "../../foundation/util/promise-util";
export async function fetchPageWithAdditionalPageRequirements(objectGraph, primaryPageRequirement, additionalRequirements) {
    var _a;
    // Data Frankensteining Pt 1. - Additional Page Requirements:
    // Additional requests that are fired *IN PARALLEL* with page request to fetch additional data needed to render page.
    // Why are these not included in a singular page fetch? I don't know.
    // This builder API is used to request data that will *definitely* be used, regardless of the content of initial page fetch's response.
    const additionalRequirementKeys = Object.keys(additionalRequirements);
    const additionalPageRequirementPromises = additionalRequirementKeys.map(async (key) => {
        return await additionalRequirements[key];
    });
    const allPageRequirements = await allMixed([primaryPageRequirement, ...additionalPageRequirementPromises]);
    const primaryPageDataResult = allPageRequirements[0];
    const primaryPageData = primaryPageDataResult.value;
    if (!primaryPageDataResult.success || isNothing(primaryPageData)) {
        throw (_a = primaryPageDataResult.error) !== null && _a !== void 0 ? _a : new Error("Unknown primaryPageData error");
    }
    const additionalData = {};
    const additionalPageRequirements = allPageRequirements.slice(1);
    for (const [index, additionalPageRequirement] of additionalPageRequirements.entries()) {
        const additionalRequirementKey = additionalRequirementKeys[index];
        if (additionalPageRequirement.success) {
            additionalData[additionalRequirementKey] = additionalPageRequirement.value;
        }
        else {
            additionalData[additionalRequirementKey] = null;
            objectGraph.console.log(`Builder - failed to fetch additionalPageRequirement ${additionalRequirementKey}, reason: ${additionalPageRequirement.error}`);
        }
    }
    return {
        primaryPageData,
        additionalData,
    };
}
//# sourceMappingURL=additional-page-requirement-util.js.map